 SELECT DISTINCT B.COTACAO,
        B.PESSOA, 
        P.NOME, 
        CASE
	    	WHEN P.TIPOPESSOA = 'F'
	    	THEN '**' || SUBSTR(P.CNPJ_CPF,3,5) || '****'
	    	ELSE P.CNPJ_CPF
	    END as CNPJCPF,
        B.DATA,
        (SELECT MIN(EA_DATA.DATACRIACAO)
         FROM ${db.compras.schema}.CLLISTAARQUIVOS LA_DATA
         LEFT JOIN ${db.compras.schema}.ARQUIVO A_DATA ON LA_DATA.IDARQUIVO = A_DATA.ID
         LEFT JOIN schema_eloarquivo.ARQUIVO EA_DATA ON EA_DATA.ID = A_DATA.IDARQUIVO
         WHERE LA_DATA.IDCHAVE = 'C' || B.ENTIDADE || '-' || B.EXERCICIO || '-' || B.COTACAO || '-' || B.PESSOA) AS DATAPUBLICACAO
   FROM ${db.compras.schema}.CLCOTACAO B
   LEFT JOIN ${db.compras.schema}.CLLICITACAO A
     ON A.ENTIDADE = B.ENTIDADE  
    AND A.EXERCICIO = B.EXERCICIO  
    AND A.COTACAO = B.COTACAO
   LEFT JOIN ${db.compras.schema}.CLANEXO AN
     ON B.entidade = AN.entidade
    AND B.anexo    = AN.CODIGOANEXO
   LEFT JOIN ${db.compras.schema}.CLANEXOITEM ANI
     ON ANI.entidade = AN.entidade
    AND ANI.codigoanexo = AN.codigoanexo
   LEFT JOIN ${db.compras.schema}.PESSOA P 
     ON B.PESSOA = P.PESSOA
  WHERE (A.ENTIDADE = :entidade AND A.EXERCICIO = :exercicio AND A.TIPOLICITACAO = :tipoLicitacao AND A.LICITACAO = :licitacao)
     OR (ANI.ENTIDADELICITACAO = :entidade AND ANI.EXERCICIOLICITACAO = :exercicio AND ANI.TIPOLICITACAO = :tipoLicitacao AND ANI.LICITACAO = :licitacao)
  ORDER BY P.NOME
