SELECT RES.ENTIDADE,
       PES.NOME NOME,
       RES.ESTAGIARIO CODIGO,
       LOT.DESCRICAO LOTACAO,
       RLT.DESCRICAO LOCALTRABALHO,
       RHT.ENTRADA HORARIOENTRADA,
       RHT.SAIDAINTERVALO HORARIOSAIDAINTERVALO,
       RHT.ENTRADAINTERVALO HORARIOENTRADAINTERVALO,
       RHT.SAIDA HORARIOSAIDA,
       RCG.DESCRICAO CARGO,
       RCG.HORASSEMANAIS,
       RFX.FAIXA FAIXA,
       (SELECT MIN (DATAINICIO)
          FROM ${db.aise.schema}.RHESTAGIARIOPERIODO REPX
         WHERE RES.ENTIDADE = REPX.ENTIDADE
           AND RES.ESTAGIARIO = REPX.ESTAGIARIO) INICIOCONTRATO,
       COALESCE (RES.DATARESCISAO, (SELECT MAX (DATAFIM)
                                      FROM ${db.aise.schema}.RHESTAGIARIOPERIODO REPX
                                     WHERE RES.ENTIDADE = REPX.ENTIDADE
                                       AND RES.ESTAGIARIO = REPX.ESTAGIARIO
                                       AND EXTRACT(YEAR FROM DATAFIM) >= :exercicio)) TERMINOCONTRATO,
		RFX.VALOR VALORFAIXA
  FROM ${db.aise.schema}.RHESTAGIARIO RES
  JOIN ${db.aise.schema}.PESSOA PES
    ON RES.PESSOA = PES.PESSOA
  LEFT JOIN ${db.aise.schema}.RHLOTACAO LOT
    ON RES.ENTIDADE = LOT.ENTIDADE
   AND RES.MODELOLOTACAO = LOT.MODELOLOTACAO
   AND RES.NIVELLOTACAO = LOT.NIVELLOTACAO
   AND RES.LOTACAO = LOT.LOTACAO
  LEFT JOIN ${db.aise.schema}.RHLOCALDETRABALHO RLT
    ON RES.LOCALDETRABALHO = RLT.LOCALDETRABALHO
  LEFT JOIN ${db.aise.schema}.RHHORARIOTRABALHO RHT
    ON RES.ENTIDADE = RHT.ENTIDADE
   AND RES.HORARIOTRABALHO = RHT.HORARIOTRABALHO
  LEFT JOIN ${db.aise.schema}.RHCARGO RCG
    ON RES.ENTIDADE = RCG.ENTIDADE
   AND RES.CARGO = RCG.CARGO
  LEFT JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALFAIXA RFX
    ON RES.ENTIDADE = RFX.ENTIDADE
   AND RES.QUADROSALARIAL = RFX.QUADROSALARIAL
   AND RES.GRUPOOCUPACIONAL = RFX.GRUPOOCUPACIONAL
   AND RES.NIVEL = RFX.NIVEL
   AND RES.FAIXA = RFX.FAIXA
 WHERE RES.ENTIDADE = :entidade
   AND COALESCE(EXTRACT (YEAR FROM DATARESCISAO),
                EXTRACT (YEAR FROM (SELECT MAX(DATAFIM)
                                      FROM ${db.aise.schema}.RHESTAGIARIOPERIODO REPX
                                     WHERE RES.ENTIDADE = REPX.ENTIDADE
                                       AND RES.ESTAGIARIO = REPX.ESTAGIARIO)), 9999) >= :exercicio
   AND (SELECT EXTRACT(YEAR FROM MIN(DATAINICIO))
          FROM ${db.aise.schema}.RHESTAGIARIOPERIODO REPX
         WHERE RES.ENTIDADE = REPX.ENTIDADE
           AND RES.ESTAGIARIO = REPX.ESTAGIARIO) <= :exercicio
   AND ((RFX.ENTIDADE IS NULL) OR 
        (RFX.INICIOVALIDADE = (SELECT MAX(INICIOVALIDADE)
                                 FROM ${db.aise.schema}.RHGRUPOOCUPACIONALFAIXA GOFX
                                WHERE RFX.ENTIDADE = GOFX.ENTIDADE
                                  AND RFX.QUADROSALARIAL = GOFX.QUADROSALARIAL
                                  AND RFX.GRUPOOCUPACIONAL = GOFX.GRUPOOCUPACIONAL
                                  AND RFX.NIVEL = GOFX.NIVEL
                                  AND RFX.FAIXA = GOFX.FAIXA
                                  AND GOFX.INICIOVALIDADE <= TO_DATE(:exercicio || '-12-01', 'YYYY-MM-DD'))))