SELECT CF.ENTIDADE,
       CF.CARGO,
       C.DESCRICAO,
       CL.DESCRICAO AS TIPO,
       CF.QUADROSALARIAL,
       QS.DESCRICAO AS QUADROSALARIALDESC,
       CF.GRUPOOCUPACIONAL,
       GO.DESCRICAO AS GRUPOOCUPACIONALDESC,
       CF.NIVEL,
       GN.DESCRICAO AS NIVELDESC,
       C.VAGAS AS VAGASTOTAL,
       C.OCUPADAS AS VAGASOCUPADAS,
       CF.INICIOVALIDADE,
	   ATO.NUMEROATO, ATO.ANOATO 
  FROM ${db.aise.schema}.RHCARGO C
  LEFT OUTER JOIN ${db.aise.schema}.RHCARGOFAIXA CF
    ON CF.ENTIDADE = C.ENTIDADE
   AND CF.CARGO = C.CARGO
  LEFT OUTER JOIN ${db.aise.schema}.RHCLASSIFICACAOCARGO CL
    ON CL.CLASSIFICACAO = C.CLASSIFICACAO
  LEFT OUTER JOIN ${db.aise.schema}.RHQUADROSALARIAL QS
    ON CF.ENTIDADE = QS.ENTIDADE
   AND CF.QUADROSALARIAL = QS.QUADROSALARIAL
  LEFT OUTER JOIN ${db.aise.schema}.RHGRUPOOCUPACIONAL GO
    ON CF.ENTIDADE = GO.ENTIDADE
   AND CF.QUADROSALARIAL = GO.QUADROSALARIAL
   AND CF.GRUPOOCUPACIONAL = GO.GRUPOOCUPACIONAL
  LEFT OUTER JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALNIVEL GN
    ON CF.ENTIDADE = GN.ENTIDADE
   AND CF.QUADROSALARIAL = GN.QUADROSALARIAL
   AND CF.GRUPOOCUPACIONAL = GN.GRUPOOCUPACIONAL
   AND CF.NIVEL = GN.NIVEL
  LEFT OUTER JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALFAIXA GON
    ON GN.ENTIDADE = GON.ENTIDADE
   AND GN.QUADROSALARIAL = GON.QUADROSALARIAL
   AND GN.GRUPOOCUPACIONAL = GON.GRUPOOCUPACIONAL
   AND CF.INICIOVALIDADE = GON.INICIOVALIDADE
   AND GN.NIVEL = GON.NIVEL
  LEFT OUTER JOIN ${db.aise.schema}.RHMOVIMENTACAOCARGO MC
	ON C.ENTIDADE = MC.ENTIDADE 
   AND C.CARGO = MC.CARGO 
   AND MC.ESPECIE = 7
  LEFT OUTER JOIN ${db.aise.schema}.CGATO ATO
	ON MC.ENTIDADE = ATO.ENTIDADE 
   AND MC.IDATO = ATO.IDATO    
 WHERE CF.ENTIDADE = :entidade
   AND (C.SITUACAO = 'A' OR C.SITUACAO = 'M')
   AND C.VAGAS > 0
   AND CF.INICIOVALIDADE = (
       SELECT MAX(X.INICIOVALIDADE)
         FROM ${db.aise.schema}.RHCARGOFAIXA X
         JOIN ${db.aise.schema}.RHGRUPOOCUPACIONALCOMPETENCIA GOCX ON X.ENTIDADE = GOCX.ENTIDADE
          AND X.QUADROSALARIAL = GOCX.QUADROSALARIAL
          AND X.GRUPOOCUPACIONAL = GOCX.GRUPOOCUPACIONAL
          AND X.NIVEL = GOCX.NIVEL
          AND X.INICIOVALIDADE = GOCX.INICIOVALIDADE
        WHERE CF.ENTIDADE = X.ENTIDADE
          AND CF.CARGO = X.CARGO
          AND GOCX.SITUACAO = 1
          AND EXTRACT(YEAR FROM X.INICIOVALIDADE) <= :exercicio
       )