/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EntidadeProtocoloService {
    private final EntidadeContabilidadeService entidadeService;
    private final PortalParametroRepository portalParametroRepository;

    public EntidadeProtocoloService(EntidadeContabilidadeService entidadeService, PortalParametroRepository portalParametroRepository) {
        this.entidadeService = entidadeService;
        this.portalParametroRepository = portalParametroRepository;
    }

    public Optional<Long> getEntidadeProtocolo(Long entidade) {
        long entidadeProtocolo = 0L;
        if (entidade > 0L) {
            PortalParametroContabil parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ENTIDADE_PROTOCOLO);
            if (Objects.nonNull(parametro) && StringUtils.isNotBlank((String)parametro.getValor())) {
                entidadeProtocolo = Long.parseLong(parametro.getValor());
            }
            if (entidadeProtocolo <= 0L && Objects.nonNull(parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(this.entidadeService.getEntidadePrincipal().orElse(new Entidade()).getId(), Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ENTIDADE_PROTOCOLO)) && StringUtils.isNotBlank((String)parametro.getValor())) {
                entidadeProtocolo = Long.parseLong(parametro.getValor());
            }
        }
        if (entidadeProtocolo <= 0L) {
            return Optional.empty();
        }
        return Optional.of(entidadeProtocolo);
    }
}

