/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="protocolo.unidadefederacao")
public class UnidadeFederacao
implements EloEntity<String> {
    private static final String[] ufBrasil = new String[]{"AC", "AL", "AP", "AM", "BA", "BR", "CE", "DF", "ES", "GO", "MA", "MT", "MS", "MG", "PA", "PB", "PR", "PE", "PI", "RJ", "RN", "RS", "RO", "RR", "SC", "SP", "SE", "TO"};
    @Id
    @Length(max=2)
    @Column(name="unidadefederacao")
    @Caption(value="Sigla")
    private @Length(max=2) String id;
    @Length(max=50)
    @Caption(value="Unidade Federa\u00e7\u00e3o")
    @NotBlank
    private @Length(max=50) @NotBlank String descricao;
    @Caption(value="Estrangeiro")
    @Transient
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean estrangeiro;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Boolean getEstrangeiro() {
        this.estrangeiro = UnidadeFederacao.isEstrangeiro((String)this.id);
        return this.estrangeiro;
    }

    public static Boolean isEstrangeiro(String uf) {
        return uf != null ? Boolean.valueOf(!Arrays.asList(ufBrasil).contains(uf.toUpperCase())) : null;
    }

    public static String getUfAsList() {
        return String.join((CharSequence)", ", (CharSequence[])Arrays.asList(ufBrasil).stream().map(uf -> "'" + uf + "'").toArray(String[]::new));
    }

    public static UnidadeFederacao of(String id) {
        UnidadeFederacao uf = new UnidadeFederacao();
        uf.setId(id);
        return uf;
    }

    @Generated
    public String toString() {
        return "UnidadeFederacao(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", estrangeiro=" + this.getEstrangeiro() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnidadeFederacao)) {
            return false;
        }
        UnidadeFederacao other = (UnidadeFederacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnidadeFederacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

