/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.GastosPortal;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoManutencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoListDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.VeiculoToDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.VeiculoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.VeiculoParams;
import br.com.elotech.portaltransparencia.contabportal.service.VeiculoService;
import br.com.elotech.portaltransparencia.rsql.CustomRsqlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;

public class VeiculoServiceImpl
implements VeiculoService {
    private static final long PARAMETRO_TIPO_GASTO = 23L;
    private final VeiculoRepository veiculoRepository;
    private final PortalParametroService portalParametroService;
    private final EntityManager em;
    private final DBConfigProperties dbConfigProperties;

    @Autowired
    public VeiculoServiceImpl(VeiculoRepository veiculoRepository, EntityManager em, PortalParametroService portalParametroService, DBConfigProperties dbConfigProperties) {
        this.veiculoRepository = veiculoRepository;
        this.em = em;
        this.portalParametroService = portalParametroService;
        this.dbConfigProperties = dbConfigProperties;
    }

    public Page<VeiculoListDTO> findByEntidade(Long entidade, Long exercicio, String search, Pageable pageable) {
        StringBuilder searchBuilder = new StringBuilder();
        searchBuilder.append("id.tipo=='V'");
        if (Objects.nonNull(search)) {
            searchBuilder.append(" and ");
            searchBuilder.append(search);
        }
        Specification specification = CustomRsqlUtils.createSpecFrom((EntityManager)this.em, (String)searchBuilder.toString(), (String)this.dbConfigProperties.getContabilidade().getSchema());
        boolean paramIncluiMovimentados = "S".equals(this.portalParametroService.getPortalParametroValor(entidade, exercicio, Parametros.PARAM_VEICULOS_MOVIMENTADOS));
        Specification & Serializable specEntidade = (Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(cb.equal((Expression)root.get("id").get("entidade"), (Object)entidade));
            Predicate compartilha = cb.equal((Expression)root.get("bem").get("compartilha"), (Object)"S");
            if (paramIncluiMovimentados) {
                Subquery subQuery = query.subquery(GastosPortal.class);
                Root subQueryRoot = subQuery.from(GastosPortal.class);
                subQuery.select((Expression)subQueryRoot);
                subQuery.where((Expression)cb.and(new Predicate[]{cb.equal((Expression)subQueryRoot.get("id").get("veiculo"), (Expression)root.get("id").get("bem")), cb.equal((Expression)subQueryRoot.get("id").get("entidadeBem"), (Expression)root.get("id").get("entidade")), cb.equal((Expression)subQueryRoot.get("id").get("entidade"), (Object)entidade)}));
                compartilha = cb.and((Expression)compartilha, (Expression)cb.exists(subQuery));
            }
            predicates.add(compartilha);
            return cb.or(predicates.toArray(new Predicate[0]));
        };
        return this.veiculoRepository.findAll(specification.and((Specification)specEntidade), pageable).map((Function)new VeiculoToDTO());
    }

    public List<VeiculoGastoDTO> getGastosVeiculo(VeiculoParams params) {
        if (this.validarParametros(params)) {
            String tipoGasto = this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), Long.valueOf(23L));
            return this.veiculoRepository.getGastosVeiculo(params, tipoGasto);
        }
        return new ArrayList<VeiculoGastoDTO>();
    }

    private boolean validarParametros(VeiculoParams params) {
        return Objects.nonNull(params) && Objects.nonNull(params.getEntidade()) && Objects.nonNull(params.getExercicio()) && Objects.nonNull(params.getVeiculo());
    }

    public List<PatrimonioAlienacao> findAlienacoes() {
        return this.veiculoRepository.findAlienacoes();
    }

    public VeiculoDTO findVeiculo(VeiculoParams params) {
        VeiculoDTO veiculoDTO = this.veiculoRepository.findVeiculo(params);
        if (Objects.nonNull(veiculoDTO)) {
            veiculoDTO.setArquivos(this.veiculoRepository.findVeiculoArquivos(params));
        }
        return veiculoDTO;
    }

    public List<VeiculoGastoManutencaoDTO> findGastosManutencaoByVeiculo(VeiculoParams params) {
        return this.veiculoRepository.findGastosManutencaoByVeiculo(params);
    }

    public List<VeiculoGastoManutencaoDTO> findGastosPneuByVeiculo(VeiculoParams params) {
        return this.veiculoRepository.findGastosPneuByVeiculo(params);
    }

    public List<VeiculoGastoManutencaoDTO> findGastosBateriaByVeiculo(VeiculoParams params) {
        return this.veiculoRepository.findGastosBateriaByVeiculo(params);
    }

    public List<VeiculoGastoManutencaoDTO> findGastosAbastecimentoByVeiculo(VeiculoParams params) {
        return this.veiculoRepository.findGastosAbastecimentoByVeiculo(params);
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return this.veiculoRepository.findUltimaAtualizacao(params);
    }
}

