/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.QuadroPessoalDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoAiseOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.QuadroPessoalService;
import br.com.elotech.portaltransparencia.folhaportal.service.QuadroPessoalServiceOxy;
import br.com.elotech.reportexport.exporter.BaseExport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class QuadroPessoalServiceImpl
implements QuadroPessoalService {
    private final IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService;
    private final QuadroPessoalServiceOxy serviceOxy;
    private final EntidadeAiseService entidadeAiseService;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final BaseExport baseExport;

    public Page<QuadroPessoalDTO> findQuadrosPessoal(CargoParams params, Pageable pageable) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
            return this.serviceOxy.findQuadrosPessoal(params, pageable);
        }
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public List<QuadroPessoalDTO> findListQuadrosPessoal(CargoParams params) {
        return this.serviceOxy.findListQuadrosPessoal(params);
    }

    public String findNomeEntidadeById(Long entidadeId) {
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)entidadeId);
        return Objects.nonNull(entidade) ? entidade.getNome() : "";
    }

    @Generated
    public QuadroPessoalServiceImpl(IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService, QuadroPessoalServiceOxy serviceOxy, EntidadeAiseService entidadeAiseService, EntidadeContabilidadeRepository entidadeRepository, BaseExport baseExport) {
        this.integracaoAiseOxyService = integracaoAiseOxyService;
        this.serviceOxy = serviceOxy;
        this.entidadeAiseService = entidadeAiseService;
        this.entidadeRepository = entidadeRepository;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

