/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.CreditoAdicionalDotacaoFeignClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CreditosAdicionaisDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.CreditosAdicionaisParams;
import br.com.elotech.portaltransparencia.contabportal.service.CreditosAdicionaisService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class CreditosAdicionaisOxyService
implements CreditosAdicionaisService {
    private final CreditoAdicionalDotacaoFeignClient feignClient;

    public Page<CreditosAdicionaisDTO> findCreditosAdicionais(CreditosAdicionaisParams params, Pageable pageable) {
        EloPage saldoCreditosAdicionais = this.feignClient.getSaldoDotacoes(this.adapterSearch(params), params.getEntidade(), params.getExercicio(), this.adapterPage(pageable));
        return new PageImpl(saldoCreditosAdicionais.getContent().stream().map(CreditosAdicionaisDTO::ofDTOContabil).collect(Collectors.toList()), pageable, saldoCreditosAdicionais.getTotalElements());
    }

    private Pageable adapterPage(Pageable page) {
        List<Object> orders = new ArrayList();
        if (page.getSort().isSorted()) {
            orders = page.getSort().toList().stream().map(sort -> {
                switch (sort.getProperty()) {
                    case "fonterecurso": {
                        return new Sort.Order(sort.getDirection(), "fonteRecurso.codigo");
                    }
                    case "valorinicial": {
                        return new Sort.Order(sort.getDirection(), "valor");
                    }
                    case "decreto": {
                        return new Sort.Order(sort.getDirection(), "creditoAdicional.decretoLeisAtos.numero");
                    }
                    case "natureza": {
                        return new Sort.Order(sort.getDirection(), "operacao");
                    }
                }
                return new Sort.Order(sort.getDirection(), "dotacao.codigo");
            }).collect(Collectors.toList());
        }
        return PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by(orders));
    }

    private String adapterSearch(CreditosAdicionaisParams params) {
        ArrayList<String> filters = new ArrayList<String>();
        if (Strings.isNotBlank((String)params.getDespesa())) {
            filters.add(String.format("dotacao.codigo==*%s*", params.getDespesa().replaceAll("\\.", "")));
        }
        if (Strings.isNotBlank((String)params.getNroDecreto())) {
            filters.add(String.format("creditoAdicional.decretoLeisAtos.numero==%s", params.getNroDecreto()));
        }
        return String.join((CharSequence)";", filters);
    }

    @Generated
    public CreditosAdicionaisOxyService(CreditoAdicionalDotacaoFeignClient feignClient) {
        this.feignClient = feignClient;
    }
}

