/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.contabilidade.client.LiquidacaoFeignClient;
import br.com.elotech.contabilidade.client.PagamentoFeignClient;
import br.com.elotech.contabilidade.client.dto.LiquidacaoSaldoValoresDTO;
import br.com.elotech.contabilidade.client.params.LiquidacaoParams;
import br.com.elotech.contabilidade.client.params.PagamentoParams;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ContaPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LiquidacaoRepository;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class LiquidacaoOxyRepositoryImpl
implements LiquidacaoRepository {
    private static final String VALOR = "valor";
    private static final String DATA_FIM = "dataFim";
    private static final String DATA_INICIO = "dataInicio";
    private static final String EMPENHO = "empenho";
    private static final String LIQUIDACAO = "liquidacao";
    private static final String APTOS_PAGAMENTO = "aptos-pagamentos";
    private static final HashMap<String, BiFunction<Sort.Order, String, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, BiFunction<String, String, String>> FILTERS = new HashMap();
    private static final String DESPESA_ORCAMENTARIA = "2";
    private final PagamentoFeignClient pagamentoFeignClient;
    private final LiquidacaoFeignClient liquidacaoFeignClient;

    public Page<LiquidacaoDTO> findLiquidacoesAPagar(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params, Pageable pageable) {
        LiquidacaoParams liquidacaoParams = new LiquidacaoParams();
        liquidacaoParams.setEntidade(params.getEntidade().orElse(0L));
        liquidacaoParams.setExercicio(params.getExercicio().orElse(0L));
        liquidacaoParams.setDataInicio(params.getDataInicial());
        liquidacaoParams.setDataFim(params.getDataFinal());
        liquidacaoParams.setOnlyRestoPagar(params.getIsPendentes());
        liquidacaoParams.setOnlySaldoWithAProcessar(Boolean.TRUE);
        EloPage liquidacoes = this.liquidacaoFeignClient.findAllLiquidacoesSaldo(this.buildSearch(params, ";"), this.buildSort(pageable, Boolean.valueOf(false)), liquidacaoParams);
        ArrayList liquidacoesDTO = new ArrayList();
        liquidacoes.getContent().forEach(l -> liquidacoesDTO.add(new LiquidacaoDTO(l)));
        return new PageImpl(liquidacoesDTO, pageable, liquidacoes.getTotalElements());
    }

    public Page<LiquidacaoDTO> findAgendaPrevisaoPagamento(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params, Pageable pageable) {
        return this.findLiquidacoesAPagar(params, pageable);
    }

    public Page<LiquidacaoDTO> findLiquidacoesPagas(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params, Pageable pageable) {
        PagamentoParams pagamentoParams = new PagamentoParams();
        pagamentoParams.setEntidade(params.getEntidade().orElse(0L));
        pagamentoParams.setExercicio(params.getExercicio().orElse(0L));
        pagamentoParams.setDataInicio(params.getDataInicial());
        pagamentoParams.setDataFim(params.getDataFinal());
        pagamentoParams.setSomenteEmpenhosExercicio(params.getIsPorExercicio());
        pagamentoParams.setSomenteEmpenhosRestos(params.getIsPendentes());
        EloPage pagamentos = this.pagamentoFeignClient.findAllPagamentosSaldo(this.buildSearchPagamento(params, ";liquidacao."), this.buildSort(pageable, Boolean.valueOf(true)), pagamentoParams);
        ArrayList liquidacoes = new ArrayList();
        pagamentos.getContent().forEach(pagamento -> liquidacoes.add(new LiquidacaoDTO(pagamento)));
        return new PageImpl(liquidacoes, pageable, pagamentos.getTotalElements());
    }

    public LiquidacaoDTO findLiquidacoesPagasTotal(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params) {
        return new LiquidacaoDTO();
    }

    public LiquidacaoDTO findLiquidacoesAPagarTotal(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params) {
        LiquidacaoParams liquidacaoParams = new LiquidacaoParams();
        liquidacaoParams.setEntidade(params.getEntidade().orElse(0L));
        liquidacaoParams.setExercicio(params.getExercicio().orElse(0L));
        liquidacaoParams.setDataInicio(params.getDataInicial());
        liquidacaoParams.setDataFim(params.getDataFinal());
        liquidacaoParams.setOnlyRestoPagar(params.getIsPendentes());
        liquidacaoParams.setOnlySaldoWithAProcessar(Boolean.TRUE);
        LiquidacaoSaldoValoresDTO valoresDTO = this.liquidacaoFeignClient.findTotalWithMovimentacao(this.buildSearch(params, ";"), liquidacaoParams);
        return LiquidacaoDTO.builder().valor(valoresDTO.getLiquidado()).saldo(valoresDTO.getSaldoDisponivel()).build();
    }

    public ContaPagamentoDTO findContaPagamento(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params) {
        throw new NotImplementedException();
    }

    private String buildSearch(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params, String prefix) {
        StringBuilder search = new StringBuilder();
        params.getCnpjCpf().ifPresent(cnpjCpf -> search.append((String)((BiFunction)FILTERS.get("cnpjCpf")).apply(cnpjCpf, prefix)));
        params.getNome().ifPresent(nome -> search.append((String)((BiFunction)FILTERS.get("nome")).apply(nome, prefix)));
        params.getEmpenho().ifPresent(empenho -> search.append((String)((BiFunction)FILTERS.get(EMPENHO)).apply(empenho.toString(), prefix)));
        params.getFonteRecurso().ifPresent(fonteRecurso -> search.append((String)((BiFunction)FILTERS.get("fonteRecurso")).apply(fonteRecurso, prefix)));
        if (!Strings.isNullOrEmpty((String)params.getNotaFiscal())) {
            search.append((String)((BiFunction)FILTERS.get("notaFiscal")).apply(params.getNotaFiscal(), prefix));
        }
        if (Objects.nonNull(params.getDataInicial())) {
            if (!prefix.contains(LIQUIDACAO)) {
                search.append((String)((BiFunction)FILTERS.get(DATA_INICIO)).apply(params.getDataInicial().toString(), ";dataLiquidacao"));
            } else {
                search.append((String)((BiFunction)FILTERS.get(DATA_INICIO)).apply(params.getDataInicial().toString(), ";centralPagamento.data"));
            }
        }
        if (Objects.nonNull(params.getDataFinal())) {
            if (!prefix.contains(LIQUIDACAO)) {
                search.append((String)((BiFunction)FILTERS.get(DATA_FIM)).apply(params.getDataFinal().toString(), ";dataLiquidacao"));
            } else {
                search.append((String)((BiFunction)FILTERS.get(DATA_FIM)).apply(params.getDataFinal().toString(), ";centralPagamento.data"));
            }
        }
        if (prefix.contains(LIQUIDACAO)) {
            search.append(";tipoDespesa==").append(DESPESA_ORCAMENTARIA);
        }
        if (APTOS_PAGAMENTO.equals(params.getTipo())) {
            search.append(";empenho.tipoLicitacao.codigo!=0");
        }
        if (Objects.nonNull(params.getIsCovid()) && SimNao.toBoolean((String)params.getIsCovid().replace("'", "")).booleanValue()) {
            search.append(prefix + "empenho.covid==true");
        }
        if (search.toString().isEmpty()) {
            return "";
        }
        return search.substring(1);
    }

    private String buildSearchPagamento(br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams params, String prefix) {
        StringBuilder search = new StringBuilder(";").append(this.buildSearch(params, prefix));
        if (Boolean.TRUE.equals(params.getIsPorExercicio())) {
            search.append((String)((BiFunction)FILTERS.get("somenteExercicio")).apply(params.getExercicio().orElse(0L).toString(), prefix));
        }
        if (Boolean.TRUE.equals(params.getIsPendentes())) {
            search.append((String)((BiFunction)FILTERS.get("somenteRestos")).apply(params.getExercicio().orElse(0L).toString(), prefix));
        }
        return search.substring(1);
    }

    private Pageable buildSort(Pageable pageable, Boolean pagamento) {
        ArrayList orders = new ArrayList();
        if (pageable.getSort().isSorted()) {
            pageable.getSort().toList().forEach(sort -> {
                if (pagamento.booleanValue()) {
                    this.addSortPagamento(orders, sort);
                } else {
                    this.addSortLiquidacao(orders, sort);
                }
            });
        }
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }

    private void addSortLiquidacao(List<Sort.Order> orders, Sort.Order sort) {
        if (sort.getProperty().equals("data")) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "dataLiquidacao"));
        } else if (sort.getProperty().equals(VALOR)) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, VALOR));
        } else {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, ""));
        }
    }

    private void addSortPagamento(List<Sort.Order> orders, Sort.Order sort) {
        if (sort.getProperty().equals("data")) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "centralPagamento.data"));
        } else if (sort.getProperty().equals("valorParametro")) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "valorLiquido"));
        } else {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "liquidacao."));
        }
    }

    @Generated
    public LiquidacaoOxyRepositoryImpl(PagamentoFeignClient pagamentoFeignClient, LiquidacaoFeignClient liquidacaoFeignClient) {
        this.pagamentoFeignClient = pagamentoFeignClient;
        this.liquidacaoFeignClient = liquidacaoFeignClient;
    }

    static {
        ORDERS.put("fonteRecurso", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.fonteRecurso"));
        ORDERS.put("ordemFonteRecurso", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.fonteRecurso"));
        ORDERS.put("data", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix));
        ORDERS.put(EMPENHO, (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.numeroEmpenho"));
        ORDERS.put("noLiquidacao", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "numeroLiquidacao"));
        ORDERS.put("fornecedor", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.credor.cnpjCpf"));
        ORDERS.put("tipoLicitacao", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.tipoLicitacao.codigo"));
        ORDERS.put("licitacao", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.licitacao.numeroLicitacao"));
        ORDERS.put("valorParametro", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix));
        ORDERS.put(VALOR, (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix));
        FILTERS.put("cnpjCpf", (filter, prefix) -> prefix + "empenho.credor.cnpjCpf=='*" + filter + "*'");
        FILTERS.put("nome", (filter, prefix) -> prefix + "empenho.credor.nome=='*" + filter + "*'");
        FILTERS.put(EMPENHO, (filter, prefix) -> prefix + "empenho.numeroEmpenho==" + filter);
        FILTERS.put("notaFiscal", (filter, prefix) -> prefix + "documentos.numeroDocumento=='*" + filter + "*'");
        FILTERS.put(DATA_INICIO, (filter, prefix) -> prefix + ">=" + filter);
        FILTERS.put(DATA_FIM, (filter, prefix) -> prefix + "<=" + filter);
        FILTERS.put("somenteExercicio", (filter, prefix) -> prefix + "empenho.exercicio.exercicio==" + filter);
        FILTERS.put("somenteRestos", (filter, prefix) -> prefix + "empenho.exercicio.exercicio!=" + filter);
        FILTERS.put("fonteRecurso", (filter, prefix) -> prefix + "empenho.fonteRecurso.codigo=='" + filter + "'");
    }
}

