/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.domain.dto;

import br.com.elotech.oxy.adm.compras.client.portal.ObrasPortalDTO;
import br.com.elotech.oxy.adm.compras.domain.enums.SituacaoIntervencaoEnum;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.enums.SituacaoObra;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class ObraDTO {
    private Long entidade;
    private Long exercicio;
    private Long idOrdemServico;
    private Long ordemServico;
    private String descricaoBem;
    private String descricao;
    private String bem;
    private BigDecimal valorIntervencao;
    private BigDecimal valorContrato;
    private String empresa;
    private BigDecimal valorAditivo;
    private BigDecimal valorPago;
    private LocalDate data;
    private LocalDate previsaoTermino;
    private Long situacao;
    private BigDecimal percentual;
    private String objeto;
    private Long numeroContrato;
    private Long exercicioContrato;
    private String idContrato;
    private Long existePlanilha;
    private String matricula;
    private String nomeFiscal;
    private String populacaoAtendida;
    private String displayOrdemServico;
    private String displaySituacao;

    public static void setFieldsDisplay(List<ObraDTO> list) {
        for (ObraDTO obraDTO : list) {
            obraDTO.setDisplaySituacao(obraDTO.getSituacao());
            obraDTO.setDisplayOrdemServico(String.format("%d/%d", obraDTO.getOrdemServico(), obraDTO.getExercicio()));
        }
    }

    public String getSituacao() {
        return SituacaoObra.fromId((Long)this.situacao).getDescricao();
    }

    public static ObraDTO fromOxy(ObrasPortalDTO dto) {
        ObraDTO obraDTO = new ObraDTO();
        obraDTO.setEntidade(dto.getEntidade());
        obraDTO.setExercicio(dto.getExercicio());
        obraDTO.setIdOrdemServico(dto.getIdOrdemServico());
        obraDTO.setOrdemServico(dto.getOrdemServico());
        obraDTO.setDescricaoBem(dto.getDescricaoBem());
        obraDTO.setDescricao(dto.getDescricao());
        obraDTO.setBem(dto.getBem());
        obraDTO.setValorIntervencao(dto.getValorIntervencao());
        obraDTO.setValorContrato(dto.getValorContrato());
        obraDTO.setEmpresa(dto.getEmpresa());
        obraDTO.setValorAditivo(dto.getValorAditivo());
        obraDTO.setValorPago(dto.getValorPago());
        obraDTO.setData(dto.getData());
        obraDTO.setPercentual(dto.getPercentual());
        obraDTO.setObjeto(dto.getObjeto());
        obraDTO.setNumeroContrato(dto.getNumeroContrato());
        obraDTO.setExercicioContrato(dto.getExercicioContrato());
        obraDTO.setIdContrato(dto.getIdContrato());
        obraDTO.setExistePlanilha(dto.getExistePlanilha());
        obraDTO.setPrevisaoTermino(dto.getPrevisaoTermino());
        Optional.ofNullable(dto.getSituacao()).ifPresent(s -> obraDTO.setSituacao(Long.valueOf(Long.parseLong(SituacaoIntervencaoEnum.valueOf((String)s).getCodigo()))));
        return obraDTO;
    }

    @Generated
    public static ObraDTOBuilder builder() {
        return new ObraDTOBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getIdOrdemServico() {
        return this.idOrdemServico;
    }

    @Generated
    public Long getOrdemServico() {
        return this.ordemServico;
    }

    @Generated
    public String getDescricaoBem() {
        return this.descricaoBem;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getBem() {
        return this.bem;
    }

    @Generated
    public BigDecimal getValorIntervencao() {
        return this.valorIntervencao;
    }

    @Generated
    public BigDecimal getValorContrato() {
        return this.valorContrato;
    }

    @Generated
    public String getEmpresa() {
        return this.empresa;
    }

    @Generated
    public BigDecimal getValorAditivo() {
        return this.valorAditivo;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public LocalDate getPrevisaoTermino() {
        return this.previsaoTermino;
    }

    @Generated
    public BigDecimal getPercentual() {
        return this.percentual;
    }

    @Generated
    public String getObjeto() {
        return this.objeto;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Long getExercicioContrato() {
        return this.exercicioContrato;
    }

    @Generated
    public String getIdContrato() {
        return this.idContrato;
    }

    @Generated
    public Long getExistePlanilha() {
        return this.existePlanilha;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public String getNomeFiscal() {
        return this.nomeFiscal;
    }

    @Generated
    public String getPopulacaoAtendida() {
        return this.populacaoAtendida;
    }

    @Generated
    public String getDisplayOrdemServico() {
        return this.displayOrdemServico;
    }

    @Generated
    public String getDisplaySituacao() {
        return this.displaySituacao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setIdOrdemServico(Long idOrdemServico) {
        this.idOrdemServico = idOrdemServico;
    }

    @Generated
    public void setOrdemServico(Long ordemServico) {
        this.ordemServico = ordemServico;
    }

    @Generated
    public void setDescricaoBem(String descricaoBem) {
        this.descricaoBem = descricaoBem;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setBem(String bem) {
        this.bem = bem;
    }

    @Generated
    public void setValorIntervencao(BigDecimal valorIntervencao) {
        this.valorIntervencao = valorIntervencao;
    }

    @Generated
    public void setValorContrato(BigDecimal valorContrato) {
        this.valorContrato = valorContrato;
    }

    @Generated
    public void setEmpresa(String empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setValorAditivo(BigDecimal valorAditivo) {
        this.valorAditivo = valorAditivo;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setPrevisaoTermino(LocalDate previsaoTermino) {
        this.previsaoTermino = previsaoTermino;
    }

    @Generated
    public void setSituacao(Long situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    @Generated
    public void setObjeto(String objeto) {
        this.objeto = objeto;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setExercicioContrato(Long exercicioContrato) {
        this.exercicioContrato = exercicioContrato;
    }

    @Generated
    public void setIdContrato(String idContrato) {
        this.idContrato = idContrato;
    }

    @Generated
    public void setExistePlanilha(Long existePlanilha) {
        this.existePlanilha = existePlanilha;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setNomeFiscal(String nomeFiscal) {
        this.nomeFiscal = nomeFiscal;
    }

    @Generated
    public void setPopulacaoAtendida(String populacaoAtendida) {
        this.populacaoAtendida = populacaoAtendida;
    }

    @Generated
    public void setDisplayOrdemServico(String displayOrdemServico) {
        this.displayOrdemServico = displayOrdemServico;
    }

    @Generated
    public void setDisplaySituacao(String displaySituacao) {
        this.displaySituacao = displaySituacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObraDTO)) {
            return false;
        }
        ObraDTO other = (ObraDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$idOrdemServico = this.getIdOrdemServico();
        Long other$idOrdemServico = other.getIdOrdemServico();
        if (this$idOrdemServico == null ? other$idOrdemServico != null : !((Object)this$idOrdemServico).equals(other$idOrdemServico)) {
            return false;
        }
        Long this$ordemServico = this.getOrdemServico();
        Long other$ordemServico = other.getOrdemServico();
        if (this$ordemServico == null ? other$ordemServico != null : !((Object)this$ordemServico).equals(other$ordemServico)) {
            return false;
        }
        String this$descricaoBem = this.getDescricaoBem();
        String other$descricaoBem = other.getDescricaoBem();
        if (this$descricaoBem == null ? other$descricaoBem != null : !this$descricaoBem.equals(other$descricaoBem)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$bem = this.getBem();
        String other$bem = other.getBem();
        if (this$bem == null ? other$bem != null : !this$bem.equals(other$bem)) {
            return false;
        }
        BigDecimal this$valorIntervencao = this.getValorIntervencao();
        BigDecimal other$valorIntervencao = other.getValorIntervencao();
        if (this$valorIntervencao == null ? other$valorIntervencao != null : !((Object)this$valorIntervencao).equals(other$valorIntervencao)) {
            return false;
        }
        BigDecimal this$valorContrato = this.getValorContrato();
        BigDecimal other$valorContrato = other.getValorContrato();
        if (this$valorContrato == null ? other$valorContrato != null : !((Object)this$valorContrato).equals(other$valorContrato)) {
            return false;
        }
        String this$empresa = this.getEmpresa();
        String other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        BigDecimal this$valorAditivo = this.getValorAditivo();
        BigDecimal other$valorAditivo = other.getValorAditivo();
        if (this$valorAditivo == null ? other$valorAditivo != null : !((Object)this$valorAditivo).equals(other$valorAditivo)) {
            return false;
        }
        BigDecimal this$valorPago = this.getValorPago();
        BigDecimal other$valorPago = other.getValorPago();
        if (this$valorPago == null ? other$valorPago != null : !((Object)this$valorPago).equals(other$valorPago)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        LocalDate this$previsaoTermino = this.getPrevisaoTermino();
        LocalDate other$previsaoTermino = other.getPrevisaoTermino();
        if (this$previsaoTermino == null ? other$previsaoTermino != null : !((Object)this$previsaoTermino).equals(other$previsaoTermino)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        BigDecimal this$percentual = this.getPercentual();
        BigDecimal other$percentual = other.getPercentual();
        if (this$percentual == null ? other$percentual != null : !((Object)this$percentual).equals(other$percentual)) {
            return false;
        }
        String this$objeto = this.getObjeto();
        String other$objeto = other.getObjeto();
        if (this$objeto == null ? other$objeto != null : !this$objeto.equals(other$objeto)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Long this$exercicioContrato = this.getExercicioContrato();
        Long other$exercicioContrato = other.getExercicioContrato();
        if (this$exercicioContrato == null ? other$exercicioContrato != null : !((Object)this$exercicioContrato).equals(other$exercicioContrato)) {
            return false;
        }
        String this$idContrato = this.getIdContrato();
        String other$idContrato = other.getIdContrato();
        if (this$idContrato == null ? other$idContrato != null : !this$idContrato.equals(other$idContrato)) {
            return false;
        }
        Long this$existePlanilha = this.getExistePlanilha();
        Long other$existePlanilha = other.getExistePlanilha();
        if (this$existePlanilha == null ? other$existePlanilha != null : !((Object)this$existePlanilha).equals(other$existePlanilha)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        String this$nomeFiscal = this.getNomeFiscal();
        String other$nomeFiscal = other.getNomeFiscal();
        if (this$nomeFiscal == null ? other$nomeFiscal != null : !this$nomeFiscal.equals(other$nomeFiscal)) {
            return false;
        }
        String this$populacaoAtendida = this.getPopulacaoAtendida();
        String other$populacaoAtendida = other.getPopulacaoAtendida();
        if (this$populacaoAtendida == null ? other$populacaoAtendida != null : !this$populacaoAtendida.equals(other$populacaoAtendida)) {
            return false;
        }
        String this$displayOrdemServico = this.getDisplayOrdemServico();
        String other$displayOrdemServico = other.getDisplayOrdemServico();
        if (this$displayOrdemServico == null ? other$displayOrdemServico != null : !this$displayOrdemServico.equals(other$displayOrdemServico)) {
            return false;
        }
        String this$displaySituacao = this.getDisplaySituacao();
        String other$displaySituacao = other.getDisplaySituacao();
        return !(this$displaySituacao == null ? other$displaySituacao != null : !this$displaySituacao.equals(other$displaySituacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObraDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $idOrdemServico = this.getIdOrdemServico();
        result = result * 59 + ($idOrdemServico == null ? 43 : ((Object)$idOrdemServico).hashCode());
        Long $ordemServico = this.getOrdemServico();
        result = result * 59 + ($ordemServico == null ? 43 : ((Object)$ordemServico).hashCode());
        String $descricaoBem = this.getDescricaoBem();
        result = result * 59 + ($descricaoBem == null ? 43 : $descricaoBem.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $bem = this.getBem();
        result = result * 59 + ($bem == null ? 43 : $bem.hashCode());
        BigDecimal $valorIntervencao = this.getValorIntervencao();
        result = result * 59 + ($valorIntervencao == null ? 43 : ((Object)$valorIntervencao).hashCode());
        BigDecimal $valorContrato = this.getValorContrato();
        result = result * 59 + ($valorContrato == null ? 43 : ((Object)$valorContrato).hashCode());
        String $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        BigDecimal $valorAditivo = this.getValorAditivo();
        result = result * 59 + ($valorAditivo == null ? 43 : ((Object)$valorAditivo).hashCode());
        BigDecimal $valorPago = this.getValorPago();
        result = result * 59 + ($valorPago == null ? 43 : ((Object)$valorPago).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        LocalDate $previsaoTermino = this.getPrevisaoTermino();
        result = result * 59 + ($previsaoTermino == null ? 43 : ((Object)$previsaoTermino).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        BigDecimal $percentual = this.getPercentual();
        result = result * 59 + ($percentual == null ? 43 : ((Object)$percentual).hashCode());
        String $objeto = this.getObjeto();
        result = result * 59 + ($objeto == null ? 43 : $objeto.hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Long $exercicioContrato = this.getExercicioContrato();
        result = result * 59 + ($exercicioContrato == null ? 43 : ((Object)$exercicioContrato).hashCode());
        String $idContrato = this.getIdContrato();
        result = result * 59 + ($idContrato == null ? 43 : $idContrato.hashCode());
        Long $existePlanilha = this.getExistePlanilha();
        result = result * 59 + ($existePlanilha == null ? 43 : ((Object)$existePlanilha).hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        String $nomeFiscal = this.getNomeFiscal();
        result = result * 59 + ($nomeFiscal == null ? 43 : $nomeFiscal.hashCode());
        String $populacaoAtendida = this.getPopulacaoAtendida();
        result = result * 59 + ($populacaoAtendida == null ? 43 : $populacaoAtendida.hashCode());
        String $displayOrdemServico = this.getDisplayOrdemServico();
        result = result * 59 + ($displayOrdemServico == null ? 43 : $displayOrdemServico.hashCode());
        String $displaySituacao = this.getDisplaySituacao();
        result = result * 59 + ($displaySituacao == null ? 43 : $displaySituacao.hashCode());
        return result;
    }

    @Generated
    public ObraDTO() {
    }

    @Generated
    public ObraDTO(Long entidade, Long exercicio, Long idOrdemServico, Long ordemServico, String descricaoBem, String descricao, String bem, BigDecimal valorIntervencao, BigDecimal valorContrato, String empresa, BigDecimal valorAditivo, BigDecimal valorPago, LocalDate data, LocalDate previsaoTermino, Long situacao, BigDecimal percentual, String objeto, Long numeroContrato, Long exercicioContrato, String idContrato, Long existePlanilha, String matricula, String nomeFiscal, String populacaoAtendida, String displayOrdemServico, String displaySituacao) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.idOrdemServico = idOrdemServico;
        this.ordemServico = ordemServico;
        this.descricaoBem = descricaoBem;
        this.descricao = descricao;
        this.bem = bem;
        this.valorIntervencao = valorIntervencao;
        this.valorContrato = valorContrato;
        this.empresa = empresa;
        this.valorAditivo = valorAditivo;
        this.valorPago = valorPago;
        this.data = data;
        this.previsaoTermino = previsaoTermino;
        this.situacao = situacao;
        this.percentual = percentual;
        this.objeto = objeto;
        this.numeroContrato = numeroContrato;
        this.exercicioContrato = exercicioContrato;
        this.idContrato = idContrato;
        this.existePlanilha = existePlanilha;
        this.matricula = matricula;
        this.nomeFiscal = nomeFiscal;
        this.populacaoAtendida = populacaoAtendida;
        this.displayOrdemServico = displayOrdemServico;
        this.displaySituacao = displaySituacao;
    }

    @Generated
    public String toString() {
        return "ObraDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", idOrdemServico=" + this.getIdOrdemServico() + ", ordemServico=" + this.getOrdemServico() + ", descricaoBem=" + this.getDescricaoBem() + ", descricao=" + this.getDescricao() + ", bem=" + this.getBem() + ", valorIntervencao=" + this.getValorIntervencao() + ", valorContrato=" + this.getValorContrato() + ", empresa=" + this.getEmpresa() + ", valorAditivo=" + this.getValorAditivo() + ", valorPago=" + this.getValorPago() + ", data=" + this.getData() + ", previsaoTermino=" + this.getPrevisaoTermino() + ", situacao=" + this.getSituacao() + ", percentual=" + this.getPercentual() + ", objeto=" + this.getObjeto() + ", numeroContrato=" + this.getNumeroContrato() + ", exercicioContrato=" + this.getExercicioContrato() + ", idContrato=" + this.getIdContrato() + ", existePlanilha=" + this.getExistePlanilha() + ", matricula=" + this.getMatricula() + ", nomeFiscal=" + this.getNomeFiscal() + ", populacaoAtendida=" + this.getPopulacaoAtendida() + ", displayOrdemServico=" + this.getDisplayOrdemServico() + ", displaySituacao=" + this.getDisplaySituacao() + ")";
    }
}

