SELECT A.IDATO AS ID,
       A.ENTIDADE,
       B.DESCRICAO AS NATUREZA,
       A.NUMEROATO AS NUMERO,
       A.ANOATO AS EXERCICIO,
	   TEL.DESCRICAO,
       A.DATAATO AS DATA,
       V.DESCRICAO AS VEICULOPUBLICACAO,
       VP.DATAPUBLICACAO,
       VP.ANOEDICAO AS ANOINICIO,
       VP.NUMEROEDICAO,
       TDL.DESCRICAO AS TIPODOCUMENTOLEGAL,
       CASE WHEN IDARQUIVO IS NULL THEN 0 ELSE 1 END AS TOTALARQUIVO,
       A.IDARQUIVO,
       A.PATHARQUIVO AS NOMEARQUIVO,
       CAST('A' AS VARCHAR(1)) AS SISTEMA,
       A.GERAPORTALTRANSPARENCIA,
       A.PAGINA,
       A.DESCRICAO AS SUMULA
  FROM ${db.aise.schema}.CGATO A
  LEFT OUTER JOIN %s.LEIATO LA
    ON A.IDUNICO = LA.ID
  LEFT OUTER JOIN %s.TIPOLEINATUREZA B
    ON LA.TIPOLEINATUREZA = B.ID
  LEFT OUTER JOIN ${db.aise.schema}.CGATOVEICULOPUBLICACAO VP
    ON A.ENTIDADE = VP.ENTIDADE
   AND A.IDATO = VP.IDATO
  LEFT OUTER JOIN ${db.aise.schema}.VEICULOPUBLICACAO V
    ON VP.VEICULOPUBLICACAO = V.VEICULOPUBLICACAO
  LEFT OUTER JOIN ${db.aise.schema}.TIPODOCUMENTOLEGAL TDL
    ON A.IDTIPODOCUMENTOLEGAL = TDL.ID
  LEFT OUTER JOIN ${db.aise.schema}.TIPOESCOPOLEI TEL
    ON A.IDTIPOESCOPOLEI = TEL.ID 
 WHERE A.ENTIDADE = :entidade
   AND A.MODULO = '01'
   AND A.GERAPORTALTRANSPARENCIA = 'S'
   AND ((LA.MODULO IS NULL) OR (LA.MODULO <> 3))