/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.QuadroPessoalDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.contabportal.service.QuadroPessoalService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/quadro-pessoal"})
public class QuadroPessoalResource {
    private final ElotechProperties elotechProperties;
    private final QuadroPessoalService quadroPessoalService;

    public QuadroPessoalResource(ElotechProperties elotechProperties, QuadroPessoalService quadroPessoalService) {
        this.elotechProperties = elotechProperties;
        this.quadroPessoalService = quadroPessoalService;
    }

    @GetMapping(params={"competencia"})
    public ResponseEntity<List<QuadroPessoalDTO>> findQuadroPessoal(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid CargoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.quadroPessoalService.findListQuadrosPessoal(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findLeisAtosExport(HttpServletRequest request, HttpServletResponse response, @Valid CargoParams params, Pageable pageable) throws Throwable {
        return this.quadroPessoalService.exportReport(request, response, params, pageable, this.elotechProperties.getReport().getMaximoRegistros().intValue());
    }
}

