/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.repository.BairroRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.BairroParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BairroRepositoryImpl
implements BairroRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(BairroRepositoryImpl.class);
    private static final String BAIRROS = "db/sql/aise/bairros.sql";
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public BairroRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public List<String> findBairros(BairroParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String sql = FileUtils.readResourceAsString((String)BAIRROS);
        sql = Objects.nonNull(params.getDescricao()) ? sql.replace("$[filtro]", SqlUtils.andBeginsWith((String)"${db.aise.schema}", (String)"TRIM(B.DESCRICAO)", (String)params.getDescricao())) : sql.replace("$[filtro]", "");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().queryForList(sql, (SqlParameterSource)params.toJdbcParameter(), String.class);
    }
}

