SELECT CAST(CODIGO AS VARCHAR(15)) CODIGO, 
       CAST(DESCRICAO AS VARCHAR(100)) DESCRICAO
  FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA O 
 WHERE O.ENTIDADE  = :entidade
   AND O.EXERCICIO = :exercicio 
   AND O.CODIGO IN ( SELECT ORC.CODIGO 
                       FROM ${db.contabilidade.schema}.DIARIA D
                       LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
                         ON D.ENTIDADE            = E.ENTIDADE
                        AND D.EXERCICIO           = E.EXERCICIO
                        AND D.EMPENHO             = E.EMPENHO
                        AND D.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA
                       LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
                         ON E.FORNECEDOR = F.FORNECEDOR
                       LEFT OUTER JOIN ${db.contabilidade.schema}.ORCPARAMETRODESPESA ORC
                         ON ORC.CODIGO    = SUBSTR(E.PROGRAMATICA,1, 5)
                        AND ORC.ENTIDADE  = E.ENTIDADE
                        AND ORC.EXERCICIO = E.EXERCICIO
					  WHERE D.EXERCICIO   = :exercicio
                      GROUP BY ORC.CODIGO )   