/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.TipoPessoaEnumConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.portaltransparencia.protocportal.domain.Contato;
import br.com.elotech.portaltransparencia.protocportal.domain.EnderecoPessoa;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="protocolo.pessoa")
public class Pessoa
implements EloEntity<Long> {
    @Id
    @EloSequence(schema="protocolo")
    @Column(name="codpessoa")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Convert(converter=TipoPessoaEnumConverter.class)
    @Column(name="pessoa")
    private TipoPessoa tipoPessoa;
    @NotNull
    @Length(max=150)
    private @NotNull @Length(max=150) String nome;
    @Length(max=20)
    private @Length(max=20) String rg;
    private Long sequenciaEndereco;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="id.pessoa", fetch=FetchType.EAGER)
    private List<EnderecoPessoa> enderecos;
    @Column(name="cnpj_cpf")
    @Caption(value="CPF - CNPJ")
    private String cnpjCpf;
    @Embedded
    private Contato contato;
    private Long idUnico;

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public Long getSequenciaEndereco() {
        return this.sequenciaEndereco;
    }

    public void setSequenciaEndereco(Long sequenciaEndereco) {
        this.sequenciaEndereco = sequenciaEndereco;
    }

    public List<EnderecoPessoa> getEnderecos() {
        return this.enderecos;
    }

    public void addEnderecos(EnderecoPessoa ... enderecos) {
        if (this.enderecos == null) {
            this.enderecos = new ArrayList();
        }
        for (EnderecoPessoa endereco : enderecos) {
            this.enderecos.add(endereco);
        }
    }

    public Pessoa withId(Long id) {
        this.id = id;
        return this;
    }

    public Pessoa withNome(String nome) {
        this.nome = nome;
        return this;
    }

    public Pessoa withCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
        return this;
    }

    public Pessoa withTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
        return this;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public Long getIdUnico() {
        return this.idUnico;
    }

    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EnderecoPessoa fetchEnderecoPrincipal() {
        if (this.enderecos == null || this.enderecos.isEmpty()) {
            return null;
        }
        for (EnderecoPessoa enderecoPessoa : this.enderecos) {
            if (!enderecoPessoa.getId().getCodigo().equals(this.sequenciaEndereco)) continue;
            return enderecoPessoa;
        }
        return (EnderecoPessoa)this.enderecos.get(0);
    }

    public Contato getContato() {
        return this.contato;
    }

    public void setContato(Contato contato) {
        this.contato = contato;
    }

    public String fetchTelefone() {
        if (this.getContato() != null && this.getContato().getTelefone() != null) {
            return this.getContato().getTelefone();
        }
        return null;
    }

    public String fetchEmail() {
        if (this.getContato() != null && this.getContato().getEmail() != null) {
            return this.getContato().getEmail();
        }
        return null;
    }

    public String fetchCelular() {
        if (this.getContato() != null && this.getContato().getCelular() != null) {
            return this.getContato().getCelular();
        }
        return null;
    }

    @Generated
    public static PessoaBuilder builder() {
        return new PessoaBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pessoa)) {
            return false;
        }
        Pessoa other = (Pessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Pessoa(id=" + this.getId() + ", tipoPessoa=" + this.getTipoPessoa() + ", nome=" + this.getNome() + ")";
    }

    @Generated
    public Pessoa(Long id, TipoPessoa tipoPessoa, String nome, String rg, Long sequenciaEndereco, List<EnderecoPessoa> enderecos, String cnpjCpf, Contato contato, Long idUnico) {
        this.id = id;
        this.tipoPessoa = tipoPessoa;
        this.nome = nome;
        this.rg = rg;
        this.sequenciaEndereco = sequenciaEndereco;
        this.enderecos = enderecos;
        this.cnpjCpf = cnpjCpf;
        this.contato = contato;
        this.idUnico = idUnico;
    }

    @Generated
    public Pessoa() {
    }
}

