/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.patrimonio.client.VeiculoClient;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoManutencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoListDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.VeiculoParams;
import br.com.elotech.portaltransparencia.contabportal.service.VeiculoService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class VeiculoServiceOxyImpl
implements VeiculoService {
    private static final long PARAMETRO_TIPO_GASTO = 23L;
    private final VeiculoClient veiculoClient;
    private final PortalParametroService portalParametroService;

    @Autowired
    public VeiculoServiceOxyImpl(VeiculoClient veiculoClient, PortalParametroService portalParametroService) {
        this.veiculoClient = veiculoClient;
        this.portalParametroService = portalParametroService;
    }

    public Page<VeiculoListDTO> findByEntidade(Long entidade, Long exercicio, String search, Pageable pageable) {
        StringBuilder searchBuilder = new StringBuilder().append("(entidade==").append(entidade).append(" or compartilhaEntidade==true)");
        if (StringUtils.isNotBlank((String)search)) {
            if (search.contains("search=")) {
                search = search.replace("search=", "");
            }
            searchBuilder.append(" and ").append(search);
        }
        return (Page)Optional.ofNullable(this.veiculoClient.findAllByEntidade(searchBuilder.toString(), pageable)).map(veiculosPage -> new PageImpl(veiculosPage.getContent().stream().map(VeiculoListDTO::fromOxyDTO).collect(Collectors.toList()), pageable, (long)veiculosPage.getContent().size())).orElse(new PageImpl(Collections.emptyList()));
    }

    public List<VeiculoGastoDTO> getGastosVeiculo(VeiculoParams params) {
        if (this.validarParametros(params)) {
            String tipoGasto = this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), Long.valueOf(23L));
            return this.veiculoClient.getGastosVeiculo(params.toOxyObject(), tipoGasto).stream().map(VeiculoGastoDTO::fromOxyObject).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean validarParametros(VeiculoParams params) {
        return Objects.nonNull(params) && Objects.nonNull(params.getEntidade()) && Objects.nonNull(params.getExercicio()) && Objects.nonNull(params.getVeiculoOxy());
    }

    public List<PatrimonioAlienacao> findAlienacoes() {
        return Optional.ofNullable(this.veiculoClient.findAlienacoes()).map(veiculos -> veiculos.stream().map(PatrimonioAlienacao::fromOxy).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public VeiculoDTO findVeiculo(VeiculoParams params) {
        VeiculoDTO veiculoDTO = Optional.ofNullable(this.veiculoClient.findVeiculo(params.toOxyObject())).map(VeiculoDTO::fromOxyObject).orElse(new VeiculoDTO());
        veiculoDTO.setArquivos(Optional.ofNullable(this.veiculoClient.findVeiculoArquivos(params.toOxyObject())).map(response -> response.stream().map(VeiculoArquivoDTO::fromOxyObject).collect(Collectors.toList())).orElse(Collections.emptyList()));
        return veiculoDTO;
    }

    public List<VeiculoGastoManutencaoDTO> findGastosManutencaoByVeiculo(VeiculoParams params) {
        return Optional.ofNullable(this.veiculoClient.findGastosManutencaoByVeiculo(params.toOxyObject())).map(response -> response.stream().map(VeiculoGastoManutencaoDTO::fromOxyObject).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<VeiculoGastoManutencaoDTO> findGastosPneuByVeiculo(VeiculoParams params) {
        return Optional.ofNullable(this.veiculoClient.findGastosPneuByVeiculo(params.toOxyObject())).map(response -> response.stream().map(VeiculoGastoManutencaoDTO::fromOxyObject).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<VeiculoGastoManutencaoDTO> findGastosBateriaByVeiculo(VeiculoParams params) {
        return Optional.ofNullable(this.veiculoClient.findGastosBateriaByVeiculo(params.toOxyObject())).map(response -> response.stream().map(VeiculoGastoManutencaoDTO::fromOxyObject).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<VeiculoGastoManutencaoDTO> findGastosAbastecimentoByVeiculo(VeiculoParams params) {
        return Optional.ofNullable(this.veiculoClient.findGastosAbastecimentoByVeiculo(params.toOxyObject())).map(response -> response.stream().map(VeiculoGastoManutencaoDTO::fromOxyObject).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return Optional.ofNullable(this.veiculoClient.findUltimaAtualizacao(params.toOxyPatrimonioObject())).map(response -> response.stream().map(UltimaAtualizacaoDTO::fromOxyPatrimonioObject).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

