SELECT 
    ml.matricula,
    ml.modalidade,
    ml.dataobito,
    ml.percentualbeneficio,
    CASE ml.tipobeneficio
	    WHEN 'V' THEN 'Vitalício'
	    ELSE 'Temporário'
    END AS tipobeneficio,
    p.nome AS origempensao, 
    e.nome AS entidadeorigem, 
    c.descricao AS cargoorigempensao,
    CASE ml.parentesco 
	    WHEN 1 THEN 'Cônjuge ou Conivente'
	    WHEN 2 THEN 'Filho Menor'
	    WHEN 3 THEN 'Filho Inválido'
	    WHEN 4 THEN 'Filho Menor, Estudante Nível Superior'
	    WHEN 5 THEN 'Menor sob Guarda'
	    WHEN 6 THEN 'Pais (Quando Dependentes)'
	    WHEN 7 THEN 'Irmão Menor'
    END AS parentesco
 FROM ${db.aise.schema}.rhmovimentacaopessoal mp
 LEFT OUTER JOIN ${db.aise.schema}.rhmovimentacaolegal ml
    ON ml.movimentacao = mp.movimentacao
 LEFT OUTER JOIN ${db.aise.schema}.pessoa p
    ON ml.origempensao = p.pessoa
 LEFT OUTER JOIN ${db.aise.schema}.entidade e
    ON e.entidade = ml.entidadeorigem
 LEFT OUTER JOIN ${db.aise.schema}.rhcargo c
    ON c.cargo = ml.cargo