/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.DashboardFeignClient;
import br.com.elotech.contabilidade.client.DotacaoFeignClient;
import br.com.elotech.contabilidade.client.ReceitaFeignClient;
import br.com.elotech.contabilidade.client.dto.ReceitaTotalDTO;
import br.com.elotech.contabilidade.client.params.DotacaoParams;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.GastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.DashboardService;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class DashboardOxyService
implements DashboardService {
    private final DotacaoFeignClient dotacaoFeignClient;
    private final ReceitaFeignClient receitaFeignClient;
    private final DashboardFeignClient dashboardFeingClient;

    public List<ReceitaDTO> findReceitasEmpenhadosPorMes(FindReceitaParams params) {
        return this.dashboardFeingClient.getGraficoArrecadacaoDespesa(params.getEntidade(), params.getExercicio(), Boolean.FALSE).stream().map(ReceitaDTO::ofArrecadaoDespesaOxy).collect(Collectors.toList());
    }

    public List<ReceitaDTO> findReceitasDashBoardPorMes(FindReceitaParams params) {
        return this.dashboardFeingClient.getGraficoValoresReceitas(params.getEntidade(), params.getExercicio()).stream().map(ReceitaDTO::ofReceitaSaldoMesOxy).collect(Collectors.toList());
    }

    public BigDecimal getReceitaValorAtualizado(FindReceitaParams params) {
        LocalDate dataInicial = DateUtils.firstDayOfMonth((int)Month.JANUARY.getValue(), (int)params.getExercicio().intValue());
        LocalDate dataFinal = DateUtils.lastDayOfMonth((int)Month.DECEMBER.getValue(), (int)params.getExercicio().intValue());
        ReceitaTotalDTO receitaTotal = this.receitaFeignClient.getTotal(dataInicial, dataFinal, "");
        return receitaTotal.getMovimentoAtePeriodo().getPrevistoAtualizado();
    }

    public BigDecimal getDespesaValorAtualizado(FindReceitaParams params) {
        LocalDate dataInicial = DateUtils.firstDayOfMonth((int)Month.JANUARY.getValue(), (int)params.getExercicio().intValue());
        LocalDate dataFinal = DateUtils.lastDayOfMonth((int)Month.DECEMBER.getValue(), (int)params.getExercicio().intValue());
        return this.dotacaoFeignClient.getTotal(dataInicial, dataFinal, "").getMovimentoAtePeriodo().getSaldoAtualizado();
    }

    public List<GastoDTO> findGastosPessoal(FindReceitaParams params) {
        List gastos = this.dotacaoFeignClient.findAllSaldosGroupByMonth(params.getEntidade(), params.getExercicio(), DotacaoParams.builder().isPessoalEncargos(Boolean.TRUE).build()).stream().map(GastoDTO::new).collect(Collectors.toList());
        return this.acummule(gastos);
    }

    public List<GastoDTO> findGastosEducacao(FindReceitaParams params) {
        List gastos = this.dotacaoFeignClient.findAllSaldosGroupByMonth(params.getEntidade(), params.getExercicio(), DotacaoParams.builder().isEducacao(Boolean.TRUE).build()).stream().map(GastoDTO::new).collect(Collectors.toList());
        return this.acummule(gastos);
    }

    public List<GastoDTO> findGastosSaude(FindReceitaParams params) {
        List gastos = this.dotacaoFeignClient.findAllSaldosGroupByMonth(params.getEntidade(), params.getExercicio(), DotacaoParams.builder().isSaude(Boolean.TRUE).build()).stream().map(GastoDTO::new).collect(Collectors.toList());
        return this.acummule(gastos);
    }

    private List<GastoDTO> acummule(List<GastoDTO> gastos) {
        ArrayList<GastoDTO> gastosAcumulados = new ArrayList<GastoDTO>();
        gastos.sort(Comparator.comparing(GastoDTO::getMes));
        gastos.forEach(g -> {
            if (Month.JANUARY.equals(Month.of(g.getMes().intValue()))) {
                gastosAcumulados.add((GastoDTO)g);
            } else {
                GastoDTO lastGasto = (GastoDTO)Iterables.getLast((Iterable)gastosAcumulados);
                g.setValorEmpenhado(g.getValorEmpenhado().add(lastGasto.getValorEmpenhado()));
                g.setValorLiquidado(g.getValorLiquidado().add(lastGasto.getValorLiquidado()));
                g.setValorPago(g.getValorPago().add(lastGasto.getValorPago()));
                gastosAcumulados.add((GastoDTO)g);
            }
        });
        return gastosAcumulados;
    }

    @Generated
    public DashboardOxyService(DotacaoFeignClient dotacaoFeignClient, ReceitaFeignClient receitaFeignClient, DashboardFeignClient dashboardFeingClient) {
        this.dotacaoFeignClient = dotacaoFeignClient;
        this.receitaFeignClient = receitaFeignClient;
        this.dashboardFeingClient = dashboardFeingClient;
    }
}

