/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.atos.client.dto.ConvenioAnexoDTO;
import br.com.elotech.contabilidade.client.dto.AnexoDocumentoDiariaDTO;
import br.com.elotech.contabilidade.client.dto.ArquivoDTO;
import br.com.elotech.orcamento.client.dto.AudienciaPublicaAnexoDTO;
import java.util.Optional;
import lombok.Generated;

public class ArquivoPessoalDTO {
    private Long id;
    private Long idArquivo;
    private String nomeArquivo;
    private Long tamanhoArquivo;
    private String link;

    public ArquivoPessoalDTO(AnexoDocumentoDiariaDTO anexo) {
        ArquivoDTO arquivo = Optional.ofNullable(anexo.getArquivo()).orElse(new ArquivoDTO());
        this.idArquivo = arquivo.getId();
        this.nomeArquivo = arquivo.getNome();
        this.tamanhoArquivo = Optional.ofNullable(arquivo.getTamanhoArquivo()).orElse(0L);
    }

    public static ArquivoPessoalDTO of(ConvenioAnexoDTO anexo) {
        ArquivoPessoalDTO arquivo = new ArquivoPessoalDTO();
        arquivo.setIdArquivo(anexo.getId());
        arquivo.setNomeArquivo(anexo.getNome());
        arquivo.setLink(anexo.getLink());
        return arquivo;
    }

    public static ArquivoPessoalDTO of(AudienciaPublicaAnexoDTO anexo) {
        ArquivoPessoalDTO arquivo = new ArquivoPessoalDTO();
        arquivo.setIdArquivo(anexo.getId());
        arquivo.setNomeArquivo(anexo.getFile().getFileNameFormated());
        return arquivo;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdArquivo() {
        return this.idArquivo;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public Long getTamanhoArquivo() {
        return this.tamanhoArquivo;
    }

    @Generated
    public String getLink() {
        return this.link;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdArquivo(Long idArquivo) {
        this.idArquivo = idArquivo;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setTamanhoArquivo(Long tamanhoArquivo) {
        this.tamanhoArquivo = tamanhoArquivo;
    }

    @Generated
    public void setLink(String link) {
        this.link = link;
    }

    @Generated
    public ArquivoPessoalDTO() {
    }
}

