SELECT DI.ENTIDADE,
       DI.EXERCICIO,
       DI.EMPENHO,
       DI.ENTIDADEEMPENHO,
       DI.EXERCICIOEMPENHO,
       DI.NUMEROLIQUIDACAO,
       DI.UNIDADEORCAMENTARIA,
       DI.NOME,
       DI.DATASAIDA,
       DI.DESTINO,
       DI.UF,
       DI.DATARETORNO,
       DI.QUANTIDADEDIARIAS,
       DI.VALORDIARIAS,
       DI.MEIOTRANSPORTE,
       DI.VALORPASSAGEM,
       DI.MOTIVO,
       DI.CARGO,
	   DI.MATRICULA,
       DI.NUMEROPROCESSO,
       DI.ANOPROCESSO,
       DI.LOTACAO,
       DI.HORASAIDA,
	   DI.HORARETORNO,
       DI.VALOREMPENHO,
       DI.VALORANULADO,
       DI.QUANTIDADEANULACOES,
	   DI.CODIGOSECRETARIA,
       DI.SECRETARIA,
       DI.LABELCARGO,
       DI.IDTIPOOBJETIVODIARIA,
       DI.TIPOOBJETIVODIARIA,
       DI.VALORHOSPEDAGEM,
       DI.VALOREVENTO,
	   DI.NOATO,
	   DI.DATAATO,
	   DI.GASTOSTOTAIS   
  FROM (
SELECT D.ENTIDADE,
       D.EXERCICIO,
       D.EMPENHO,
       E.ENTIDADE AS ENTIDADEEMPENHO,
       E.EXERCICIO AS EXERCICIOEMPENHO,
       D.NOLIQUIDACAO AS NUMEROLIQUIDACAO,
       D.UNIDADEORCAMENTARIA,
       CASE WHEN P_BENEFICIARIO.VALOR = 'S'
            THEN F.NOME 
            ELSE B.NOME 
       END AS NOME,
       D.DATASAIDA,
       ( D.DESTINO || ' / ' || 
              COALESCE((SELECT G.UNIDADEFEDERACAO
			              FROM ${db.contabilidade.schema}.CIDADE G
						 WHERE G.CIDADE = D.IDCIDADEDESTINO),' ')) AS DESTINO,
       COALESCE(
		  ( SELECT G.UNIDADEFEDERACAO
            FROM ${db.contabilidade.schema}.CIDADE G
		    WHERE G.CIDADE = D.IDCIDADEDESTINO ),
		  CASE WHEN SUBSTR(destino, LENGTH(destino)-2, 1) IN ('-','/')
		       THEN SUBSTR(destino, LENGTH(destino)-1, 2) END, 'EX') UF,
       D.DATARETORNO,
       D.QTDEDIARIAS AS QUANTIDADEDIARIAS,
       CASE WHEN (P_BENEFICIARIO.VALOR = 'N') AND (SUBSTR(E.PROGRAMATICA, N.POSICAO, N.TAMANHO) <> '14')
            THEN NULL
            ELSE COALESCE((L.VALOR - COALESCE(EL.VALORESTLIQUIDACAO,0)), D.VLRDIARIAS)
       END AS VALORDIARIAS,
	   D.MEIOTRANSPORTE,
       D.VALORPASSAGEM,
       D.MOTIVO,
       D.CARGO,
	   D.MATRICULA,
       E.NOPROCESSO AS NUMEROPROCESSO,
       E.ANOPROCESSO,
       D.LOTACAO,
       D.HORASAIDA,       
	   D.HORARETORNO,
       CASE WHEN (P_BENEFICIARIO.VALOR = 'N') AND (SUBSTR(E.PROGRAMATICA, N.POSICAO, N.TAMANHO) <> '14')
            THEN 0
            ELSE (SELECT SUM(A.VALOR) 
                    FROM ${db.contabilidade.schema}.FICHAEMPENHO A
                   WHERE D.ENTIDADE            = A.ENTIDADE
                     AND D.EXERCICIO           = A.EXERCICIO
                     AND D.EMPENHO             = A.EMPENHO
                     AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA) 
       END AS VALOREMPENHO,
       (SELECT SUM(A.VALORANULACOES - A.VALORESTANULACOES) FROM ${db.contabilidade.schema}.FICHAEMPENHO A
          WHERE D.ENTIDADE = A.ENTIDADE
            AND D.EXERCICIO = A.EXERCICIO
            AND D.EMPENHO = A.EMPENHO
            AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
       ) AS VALORANULADO,
       (SELECT COUNT(A.EMPENHO)
          FROM ${db.contabilidade.schema}.FICHAEMPENHO A
         WHERE D.ENTIDADE = A.ENTIDADE
           AND D.EXERCICIO = A.EXERCICIO
           AND D.EMPENHO = A.EMPENHO
           AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
           AND (SELECT SUM(A.VALOR - (A.VALORANULACOES - A.VALORESTANULACOES)) FROM ${db.contabilidade.schema}.FICHAEMPENHO A
                  WHERE D.ENTIDADE = A.ENTIDADE
                    AND D.EXERCICIO = A.EXERCICIO
                    AND D.EMPENHO = A.EMPENHO
                    AND D.UNIDADEORCAMENTARIA = A.UNIDADEORCAMENTARIA
               ) < 0.01
       ) AS QUANTIDADEANULACOES,
       ORC.CODIGO AS CODIGOSECRETARIA,
       ORC.DESCRICAO AS SECRETARIA,
       CASE 
          WHEN P.VALOR = 'N' THEN 'Nome do Proponente'
          WHEN P.VALOR = 'C' THEN 'Cargo do Beneficiado'
          ELSE 'Cargo do Proponente'
       END AS LABELCARGO,
       D.IDTIPOOBJETIVODIARIA,
       T.DSTIPOOBJETIVODIARIA AS TIPOOBJETIVODIARIA,
       D.VLRHOSPEDAGEM AS VALORHOSPEDAGEM,
       D.VLREVENTO AS VALOREVENTO,
	   D.NOATO,
	   LA.DATA AS DATAATO,
	   CASE WHEN (P_BENEFICIARIO.VALOR = 'N') AND (SUBSTR(E.PROGRAMATICA, N.POSICAO, N.TAMANHO) <> '14')
            THEN SUM(COALESCE(D.VLRHOSPEDAGEM,0) + COALESCE(D.VLREVENTO,0)   + COALESCE(D.VALORPASSAGEM,0)) 
       		ELSE SUM(COALESCE(L.VALOR, D.VLRDIARIAS))    
       END AS GASTOSTOTAIS,
       D.IDSITUACAOASSINATURAELETRONICA,
       SAE.IDTIPOSITUACAO
  FROM ${db.contabilidade.schema}.DIARIA D
  LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
    ON D.ENTIDADE = E.ENTIDADE
   AND D.EXERCICIO = E.EXERCICIO
   AND D.EMPENHO = E.EMPENHO
   AND D.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA
  LEFT OUTER JOIN ${db.contabilidade.schema}.ORCPARAMETRODESPESA ORC
    ON ORC.CODIGO = SUBSTR(E.PROGRAMATICA,1, 5)
   AND ORC.ENTIDADE = E.ENTIDADE
   AND ORC.EXERCICIO = E.EXERCICIO
  LEFT OUTER JOIN ${db.contabilidade.schema}.PARAMETROS P
    ON P.ENTIDADE = D.ENTIDADE
   AND P.EXERCICIO = D.EXERCICIO
   AND P.MODULO = '3'
   AND P.CODIGO = 159
  LEFT OUTER JOIN ${db.contabilidade.schema}.PARAMETROS P_BENEFICIARIO
    ON P_BENEFICIARIO.ENTIDADE  = D.ENTIDADE
   AND P_BENEFICIARIO.EXERCICIO = D.EXERCICIO
   AND P_BENEFICIARIO.MODULO    = '3'
   AND P_BENEFICIARIO.CODIGO    = 278 
  LEFT JOIN ${db.contabilidade.schema}.TIPOOBJETIVODIARIA T
    ON T.ID = D.IDTIPOOBJETIVODIARIA   
  LEFT JOIN ${db.contabilidade.schema}.LIQUIDACAO L
    ON L.ENTIDADE = E.ENTIDADE
   AND L.EXERCICIO = E.EXERCICIO
   AND L.ANODOCORIGEM = E.EXERCICIO
   AND L.NODOCORIGEM = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
   AND L.NOLIQUIDACAO = D.NOLIQUIDACAO
  LEFT JOIN ${db.contabilidade.schema}.LEIS_ATOS LA
    ON LA.ID = D.IDATO
  LEFT JOIN ${db.contabilidade.schema}.SITUACAOASSINATURAELETRONICA SAE
    ON SAE.ID = D.IDSITUACAOASSINATURAELETRONICA
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F 
    ON F.FORNECEDOR = E.FORNECEDOR
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR B 
    ON B.FORNECEDOR = D.BENEFICIARIO
  LEFT JOIN (SELECT EST.ENTIDADE, EST.EXERCICIOLIQ, EST.TIPODOCORIGEM, EST.NODOCORIGEM, EST.ANODOCORIGEM, EST.NOLIQUIDACAO, 
				    SUM(EST.VALOR) VALORESTLIQUIDACAO 
			   FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO EST
			  GROUP BY EST.ENTIDADE, EST.EXERCICIOLIQ, EST.TIPODOCORIGEM, EST.NODOCORIGEM, EST.ANODOCORIGEM, EST.NOLIQUIDACAO ) EL 
    ON EL.ENTIDADE      = L.ENTIDADE
   AND EL.EXERCICIOLIQ  = L.EXERCICIO
   AND EL.TIPODOCORIGEM = L.TIPODOCORIGEM 
   AND EL.NODOCORIGEM   = L.NODOCORIGEM
   AND EL.ANODOCORIGEM  = L.ANODOCORIGEM
   AND EL.NOLIQUIDACAO  = L.NOLIQUIDACAO  
  LEFT JOIN ${db.contabilidade.schema}.NIVEISMODELODESPESA N 
    ON N.MODELODESPESA = 3 
   AND N.TIPO          = 'P'
   AND N.ORDEM         = 10    
GROUP BY D.ENTIDADE, D.EXERCICIO, D.EMPENHO,
         E.ENTIDADE, E.EXERCICIO, D.NOLIQUIDACAO,
         D.UNIDADEORCAMENTARIA,  
		 (CASE WHEN P_BENEFICIARIO.VALOR = 'S' 
               THEN F.NOME 
               ELSE B.NOME 
         END), 
		 D.DATASAIDA,
         D.DESTINO, D.IDCIDADEDESTINO, D.DATARETORNO, 
		 D.QTDEDIARIAS, 
		 CASE WHEN (P_BENEFICIARIO.VALOR = 'N')  AND (SUBSTR(E.PROGRAMATICA, N.POSICAO, N.TAMANHO) <> '14')
              THEN NULL
              ELSE COALESCE((L.VALOR - COALESCE(EL.VALORESTLIQUIDACAO,0)), D.VLRDIARIAS)
         END,
         D.MEIOTRANSPORTE, D.VALORPASSAGEM,
         D.MOTIVO, D.CARGO, D.MATRICULA,
         E.NOPROCESSO, E.ANOPROCESSO, D.LOTACAO,
         D.HORASAIDA, D.HORARETORNO, ORC.DESCRICAO, 
		 ORC.CODIGO, D.IDTIPOOBJETIVODIARIA,
         T.DSTIPOOBJETIVODIARIA, D.VLRHOSPEDAGEM,
         D.VLREVENTO, D.NOATO, LA.DATA, P.VALOR,
         D.IDSITUACAOASSINATURAELETRONICA, SAE.IDTIPOSITUACAO,
         P_BENEFICIARIO.VALOR,  SUBSTR(E.PROGRAMATICA, N.POSICAO, N.TAMANHO)  ) DI
 WHERE  DI.EXERCICIO = :exercicio
   AND ((DI.VALORDIARIAS  > 0) OR DI.VALORDIARIAS IS NULL)
   AND ((DI.VALORDIARIAS IS NULL) OR (DI.VALORDIARIAS <> COALESCE((SELECT SUM(EL.VALOR)
                                                                     FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO EL
                                                                    WHERE EL.ENTIDADE         = DI.ENTIDADE 
                                                                      AND EL.EXERCICIO        = DI.EXERCICIO
                                                                      AND EL.ANODOCORIGEM     = DI.EXERCICIOEMPENHO
                                                                      AND EL.UNIDADEDOCORIGEM = DI.UNIDADEORCAMENTARIA
                                                                      AND EL.NODOCORIGEM      = DI.EMPENHO 
                                                                      AND EL.NOLIQUIDACAO     = DI.NUMEROLIQUIDACAO), 0)))
