/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.HorasExtrasDetalhesDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ProcessoDisciplinarDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.RegistroPontoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosPensaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidoresHorasExtrasDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorResumoNaturezaDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorService;
import br.com.elotech.portaltransparencia.folhaportal.service.VencimentoDescontoServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.HorasExtrasDetalhesParams;
import br.com.elotech.portaltransparencia.web.rest.params.PermutaParams;
import br.com.elotech.portaltransparencia.web.rest.params.ProcessoAdministrativoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ServidorServiceOxy
implements ServidorService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final EntidadeFeignClient entidadeClient;
    private final VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy;
    private final BaseExport baseExport;

    public Page<ServidorDTO> loadServidores(ServidorParams params, Pageable pageable) {
        EloPage servidores = this.integracaoFolhaPortalTransparenciaClient.getServidores(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(servidores.getContent().stream().map(ServidorDTOConverter::portalTransparenciaServidoresDTOToServidorDTO).collect(Collectors.toList()), pageable, servidores.getTotalElements());
    }

    public Page<ServidorDTO> loadAposentadosPensionistas(ServidorParams params, Pageable pageable) {
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        return this.vencimentoDescontoServiceOxy.getLoadVencimentoEDescontos(params);
    }

    public List<RegistroPontoDTO> loadRegistroPonto(ServidorParams params) {
        return new ArrayList<RegistroPontoDTO>();
    }

    public List<String> getSituacoes(Long entidade, Long exercicio) {
        return this.integracaoFolhaPortalTransparenciaClient.findSituacoes();
    }

    public List<ServidorResumoNaturezaDTO> loadServidoresResumoNatureza(ServidorParams params) {
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        List totalServidoresPorClasse = this.integracaoFolhaPortalTransparenciaClient.getTotalServidoresPorClasse(entidade, params.getExercicio());
        if (Objects.nonNull(totalServidoresPorClasse)) {
            return totalServidoresPorClasse.stream().map(ServidorResumoNaturezaDTOConverter::toServidorResumoNaturezaDTO).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Optional<ServidorDadosPensaoDTO> loadPensaoServidor(ServidorParams params) {
        return Optional.empty();
    }

    public boolean utilizaWebService() {
        return false;
    }

    public Boolean isIntegradoOxy() {
        return true;
    }

    public Page<ProcessoDisciplinarDTO> loadProcessosDisciplinares(ProcessoAdministrativoParams params, Pageable pageable) {
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public Optional<ServidorDTO> loadServidor(ServidorParams params) {
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        return Optional.of(ServidorDTOConverter.portalTransparenciaDadosServidorDTOToServidorDTO((PortalTransparenciaDadosServidorDTO)this.integracaoFolhaPortalTransparenciaClient.getDadosServidor(entidade, params.getExercicio(), params.getMatricula())));
    }

    public Optional<ServidoresHorasExtrasDTO> loadServidoresHorasExtras(ServidorParams params) {
        return Optional.empty();
    }

    public Page<PermutaDTO> loadPermutas(PermutaParams params, Pageable pageable) {
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public List<HorasExtrasDetalhesDTO> loadHorasExtrasDetalhes(HorasExtrasDetalhesParams params) {
        return new ArrayList<HorasExtrasDetalhesDTO>();
    }

    public List<PortalTransparenciaLotacaoDTO> findVerbas(Long definicaoEvento, ServidorParams params) {
        return this.integracaoFolhaPortalTransparenciaClient.findLotacoes(ServidorParamsConverter.toLotacaoDTO((ServidorParams)params, (Long)definicaoEvento));
    }

    public List<PortalTransparenciaLotacaoServidorDTO> findVerbaDetalhes(Long definicaoEvento, ServidorParams params) {
        return this.integracaoFolhaPortalTransparenciaClient.findServidoresPorLotacao(ServidorParamsConverter.toLotacaoDTO((ServidorParams)params, (Long)definicaoEvento));
    }

    public String findNomeEntidadeById(Long entidadeId) {
        EntidadeDTO entidadeDTO = this.entidadeClient.findOne(entidadeId);
        return Objects.nonNull(entidadeDTO) ? entidadeDTO.getNome() : "";
    }

    @Generated
    public ServidorServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, EntidadeFeignClient entidadeClient, VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy, BaseExport baseExport) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.entidadeClient = entidadeClient;
        this.vencimentoDescontoServiceOxy = vencimentoDescontoServiceOxy;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

