/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoManutencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoListDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.VeiculoParams;
import br.com.elotech.portaltransparencia.contabportal.service.VeiculoService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/veiculos"})
public class VeiculoResource {
    private final VeiculoService veiculoService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public VeiculoResource(VeiculoService veiculoService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.veiculoService = veiculoService;
    }

    @GetMapping
    public ResponseEntity<Page<VeiculoListDTO>> findVeiculos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, Pageable pageable, @RequestParam(value="search", required=false) String search) {
        return ResponseEntity.ok((Object)this.veiculoService.findByEntidade(entidade, exercicio, search, pageable));
    }

    @GetMapping(value={"/veiculo"})
    public ResponseEntity<VeiculoDTO> loadVeiculo(@RequestHeader(value="entidade") Long entidade, VeiculoParams params) {
        if (params.getEntidade() == null) {
            params.setEntidade(entidade);
        }
        return ResponseEntity.ok((Object)this.veiculoService.findVeiculo(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findVeiculoExport(HttpServletRequest request, HttpServletResponse response, Pageable pageable, @RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio, @RequestParam(value="search", required=false) String search, @RequestParam(value="exportType") String exportType) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.veiculoService.findByEntidade(entidade, exercicio, search, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)entidade);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Listagem de Ve\u00edculos");
        reportParam.setClazzDTO(VeiculoListDTO.class);
        reportParam.setHeaderFields("Ve\u00edculo,Placa,Chassi,Renavan,Aquisi\u00e7\u00e3o,Centro Custo");
        reportParam.setFields("descricao,placa,chassi,renavan,dataAquisicao,centroCusto");
        float[] fieldsPerc = new float[]{3.0f, 1.2f, 1.8f, 1.0f, 1.0f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{100, 10, 50, 20, 20, 100};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/gastos"})
    public ResponseEntity<List<VeiculoGastoDTO>> findGastosVeiculo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, VeiculoParams params) {
        if (params.getEntidade() == null) {
            params.setEntidade(entidade);
        }
        params.setExercicio(exercicio);
        List gastos = this.veiculoService.getGastosVeiculo(params);
        return ResponseEntity.ok((Object)gastos);
    }

    @GetMapping(value={"/tipo-alienacao"})
    public ResponseEntity<List<PatrimonioAlienacao>> findPatrimonioAlienacao() {
        return ResponseEntity.ok((Object)this.veiculoService.findAlienacoes());
    }

    @GetMapping(value={"/manutencao"})
    public ResponseEntity<List<VeiculoGastoManutencaoDTO>> findGastosManutencaoByVeiculo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, VeiculoParams params) {
        if (params.getEntidade() == null) {
            params.setEntidade(entidade);
        }
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.veiculoService.findGastosManutencaoByVeiculo(params));
    }

    @GetMapping(value={"/pneu"}, params={"veiculo", "mes"})
    public ResponseEntity<List<VeiculoGastoManutencaoDTO>> findGastosPneuByVeiculo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, VeiculoParams params) {
        if (params.getEntidade() == null) {
            params.setEntidade(entidade);
        }
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.veiculoService.findGastosPneuByVeiculo(params));
    }

    @GetMapping(value={"/bateria"})
    public ResponseEntity<List<VeiculoGastoManutencaoDTO>> findGastosBateriaByVeiculo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, VeiculoParams params) {
        if (params.getEntidade() == null) {
            params.setEntidade(entidade);
        }
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.veiculoService.findGastosBateriaByVeiculo(params));
    }

    @GetMapping(value={"/abastecimento"})
    public ResponseEntity<List<VeiculoGastoManutencaoDTO>> findGastosAbastecimentoByVeiculo(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, VeiculoParams params) {
        if (params.getEntidade() == null) {
            params.setEntidade(entidade);
        }
        params.setExercicio(exercicio);
        List gastosAbastecimentoByVeiculo = this.veiculoService.findGastosAbastecimentoByVeiculo(params);
        return ResponseEntity.ok((Object)gastosAbastecimentoByVeiculo);
    }

    @GetMapping(value={"/ultimas-atualizacoes"})
    public ResponseEntity<List<UltimaAtualizacaoDTO>> findUltimaAtualizacao(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindExercicioParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.veiculoService.findUltimaAtualizacao(params));
    }
}

