/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.ws.config;

import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.ws.config.ServidorProperties;
import br.com.elotech.portaltransparencia.aiseportal.ws.config.ServidoresSchedule;
import br.com.elotech.portaltransparencia.aiseportal.ws.service.ServidorServiceWS;
import java.util.HashMap;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.web.client.RestTemplate;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponentsMessageSender;

@Configuration
public class WebServiceTemplateConfiguration {
    private static final String[] WS_CLASSES_PACKAGES = new String[]{"br.com.elotech.portaltransparencia.aiseportal.ws.domain"};

    @Bean
    @Profile(value={"!cloud && !eloweb"})
    public ServidoresSchedule servidoresSchedule(ServidorServiceWS servidorServiceWS, PortalParametroRepository portalParametroRepository) {
        return new ServidoresSchedule(servidorServiceWS, portalParametroRepository);
    }

    @Bean
    public HttpClient seniorWebServiceHttpClient(ServidorProperties servidorProperties) {
        RequestConfig requestConfiguration = RequestConfig.custom().setConnectionRequestTimeout(servidorProperties.getSenior().getConnectionRequestTimeout().intValue()).setConnectTimeout(servidorProperties.getSenior().getConnectTimeout().intValue()).setSocketTimeout(servidorProperties.getSenior().getSocketTimeout().intValue()).build();
        return HttpClientBuilder.create().addInterceptorFirst((HttpRequestInterceptor)new HttpComponentsMessageSender.RemoveSoapHeadersInterceptor()).setDefaultRequestConfig(requestConfiguration).build();
    }

    @Bean
    public HttpComponentsMessageSender seniorWebServiceHttpSender(HttpClient httpClient) {
        return new HttpComponentsMessageSender(httpClient);
    }

    @Bean
    public Jaxb2Marshaller seniorWebServiceMarshaller() {
        Jaxb2Marshaller jaxb2Marshaller = new Jaxb2Marshaller();
        jaxb2Marshaller.setPackagesToScan(WS_CLASSES_PACKAGES);
        HashMap marshallerProperties = new HashMap();
        jaxb2Marshaller.setMarshallerProperties(marshallerProperties);
        return jaxb2Marshaller;
    }

    @Bean
    public WebServiceTemplate seniorWebServiceTemplate(Jaxb2Marshaller marshaller, HttpComponentsMessageSender sender, ServidorProperties servidorProperties) {
        String defaultUri = servidorProperties.getSenior().getBaseUrl();
        WebServiceTemplate webServiceTemplate = new WebServiceTemplate((Marshaller)marshaller);
        webServiceTemplate.setMessageSender((WebServiceMessageSender)sender);
        webServiceTemplate.setDefaultUri(defaultUri);
        return webServiceTemplate;
    }

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.build();
    }
}

