/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.repository.CGAtoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import br.com.elotech.portaltransparencia.contabportal.service.IntegradoComUnicoService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CGAtoRepositoryImpl
implements CGAtoRepository {
    private static final String LEISATOS = "db/sql/aise/leisatos.sql";
    private static final String LEISATOS_UNICO = "db/sql/aise/leisatos_unico.sql";
    private static final String EXISTSUNICOLEIATO = "db/sql/contab/existsleiatounico.sql";
    private static final Logger LOGGER = LoggerFactory.getLogger(CGAtoRepositoryImpl.class);
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;
    @Autowired
    private final DBConfigProperties dbConfigProperties;

    @Autowired
    public CGAtoRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService, DBConfigProperties dbConfigProperties) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
        this.dbConfigProperties = dbConfigProperties;
    }

    public boolean existsDataLeiAtosUnico(LeisAtosParams params) {
        StringBuilder query = new StringBuilder(String.format(FileUtils.readResourceAsString((String)EXISTSUNICOLEIATO), this.dbConfigProperties.getUnico().getSchema()));
        query.append("\n WHERE A.ENTIDADE = :entidade");
        if (params.getAno().isPresent()) {
            query.append("\n   AND A.ANO = :ano");
        } else {
            query.append("\n   AND A.ANO = :exercicio");
        }
        List list = new ArrayList();
        list = this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
        return !list.isEmpty();
    }

    public List<LeisAtosDTO> findLeisAtos(LeisAtosParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        IntegradoComUnicoService integradoComUnicoService = new IntegradoComUnicoService(this.dbConfigProperties);
        StringBuilder query = new StringBuilder();
        if (!integradoComUnicoService.isIntegradoComUnico()) {
            query.append(FileUtils.readResourceAsString((String)LEISATOS));
        } else if (this.existsDataLeiAtosUnico(params)) {
            query.append(String.format(FileUtils.readResourceAsString((String)LEISATOS_UNICO), this.dbConfigProperties.getUnico().getSchema(), this.dbConfigProperties.getUnico().getSchema()));
        } else {
            query.append(FileUtils.readResourceAsString((String)LEISATOS));
        }
        params.getId().ifPresent(item -> query.append("\n   AND A.IDATO = :id "));
        params.getAno().ifPresent(item -> query.append("\n   AND A.ANOATO = :ano "));
        params.getNatureza().ifPresent(item -> query.append("\n   AND UPPER(B.DESCRICAO) LIKE UPPER(:natureza) "));
        params.getNumero().ifPresent(item -> query.append("\n   AND A.NUMEROATO = :numero "));
        params.getDescricaoSumula().ifPresent(item -> query.append("\n   AND UPPER(A.DESCRICAO) LIKE UPPER(:descricaoSumula) "));
        params.getDataInicial().ifPresent(item -> query.append("\n   AND A.DATAATO >= :dataInicial "));
        params.getDataFinal().ifPresent(item -> query.append("\n   AND A.DATAATO <= :dataFinal "));
        params.getTipoDocumentoLegal().ifPresent(item -> query.append("\n   AND TDL.CODIGO = :tipoDocumentoLegal "));
        LOGGER.debug(query.toString());
        LOGGER.debug(params.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LeisAtosDTO.class));
    }
}

