/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.orcamento.client.dto.ReceitaPadraoTCEDTO;
import br.com.elotech.portaltransparencia.dto.ArrecadaoDespesaDTO;
import br.com.elotech.portaltransparencia.dto.ReceitaFonteDTO;
import br.com.elotech.portaltransparencia.dto.ReceitaSaldoMesDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class ReceitaDTO {
    private String entidade = "";
    private String receita = "";
    private String descricao;
    private String fonteRecurso = "";
    private String fonteRecursoRateio = "";
    private String descricaoFonte;
    private Integer idTipoOperacaoReceita;
    private Long nivel;
    private Long inicio;
    private Long tamanho;
    private Integer mes;
    private String aceitaMovimentacao;
    private BigDecimal valorOrcado = BigDecimal.ZERO;
    private BigDecimal valorPrevisto = BigDecimal.ZERO;
    private BigDecimal valorAtualizado = BigDecimal.ZERO;
    private BigDecimal valorArrecadado = BigDecimal.ZERO;
    private BigDecimal valorEmpenhado = BigDecimal.ZERO;
    private BigDecimal valorLiquidado = BigDecimal.ZERO;
    private BigDecimal valorLancado = BigDecimal.ZERO;
    private BigDecimal valorPago = BigDecimal.ZERO;
    private LocalDate data;
    private BigDecimal repasseRecebido = BigDecimal.ZERO;
    private BigDecimal repasseConcedido = BigDecimal.ZERO;
    private BigDecimal valorDeducaoInicial = BigDecimal.ZERO;
    private BigDecimal valorDeducao = BigDecimal.ZERO;
    private BigDecimal valorRealizadoLiquido = BigDecimal.ZERO;

    public static ReceitaDTO ofReceitaTCE(ReceitaPadraoTCEDTO receitaTCE, String codigo) {
        ReceitaDTO receita = new ReceitaDTO();
        receita.setReceita(codigo);
        receita.setDescricao(receitaTCE.getDescricao());
        receita.setAceitaMovimentacao(SimNao.fromBoolean((Boolean)Optional.ofNullable(receitaTCE.getAdmiteMovimento()).orElse(Boolean.FALSE)));
        receita.setNivel(receitaTCE.getNivel());
        return receita;
    }

    public static ReceitaDTO ofReceitaSaldoMesOxy(ReceitaSaldoMesDTO receitaSaldoMes) {
        ReceitaDTO receita = new ReceitaDTO();
        receita.setMes(Integer.valueOf(receitaSaldoMes.getMes().intValue()));
        receita.setValorPrevisto(receitaSaldoMes.getValores().getPrevisto());
        receita.setValorArrecadado(receitaSaldoMes.getValores().getRealizado());
        return receita;
    }

    public static ReceitaDTO ofArrecadaoDespesaOxy(ArrecadaoDespesaDTO arrecadacaoDespesaOxy) {
        ReceitaDTO receita = new ReceitaDTO();
        receita.setMes(Integer.valueOf(arrecadacaoDespesaOxy.getMes().intValue()));
        receita.setValorArrecadado(arrecadacaoDespesaOxy.getArrecadado());
        receita.setValorEmpenhado(arrecadacaoDespesaOxy.getEmpenhado());
        receita.setRepasseRecebido(arrecadacaoDespesaOxy.getRepassesRecebidos());
        receita.setRepasseConcedido(arrecadacaoDespesaOxy.getRepassesEnviados());
        return receita;
    }

    public static ReceitaDTO ofArrecadaoDespesaCovidOxy(ArrecadaoDespesaDTO arrecadacaoDespesaOxy) {
        ReceitaDTO receita = new ReceitaDTO();
        receita.setMes(Integer.valueOf(arrecadacaoDespesaOxy.getMes().intValue()));
        receita.setValorArrecadado(arrecadacaoDespesaOxy.getArrecadado());
        receita.setValorEmpenhado(arrecadacaoDespesaOxy.getEmpenhado());
        receita.setValorLiquidado(arrecadacaoDespesaOxy.getLiquidado());
        receita.setValorPago(arrecadacaoDespesaOxy.getPago());
        return receita;
    }

    public static ReceitaDTO ofReceitaFonteOxy(ReceitaFonteDTO receitaFonteDTO) {
        ReceitaDTO receita = new ReceitaDTO();
        receita.setReceita(receitaFonteDTO.getReceita().getCodigo());
        receita.setDescricao(receitaFonteDTO.getReceita().getDescricao());
        receita.setFonteRecursoRateio(receitaFonteDTO.getFonteRecurso().getCodigo());
        receita.setDescricaoFonte(receitaFonteDTO.getFonteRecurso().getDescricao());
        receita.setValorArrecadado(receitaFonteDTO.getMovimentoAtePeriodo().getRealizado());
        receita.setValorOrcado(receitaFonteDTO.getMovimentoAtePeriodo().getPrevisto());
        receita.setValorAtualizado(receitaFonteDTO.getMovimentoAtePeriodo().getAtualizado());
        return receita;
    }

    public BigDecimal getValorOrcado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorOrcado);
    }

    public BigDecimal getValorAtualizado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorAtualizado);
    }

    public BigDecimal getValorArrecadado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorArrecadado);
    }

    public BigDecimal getValorEmpenhado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorEmpenhado);
    }

    public BigDecimal getValorLiquidado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorLiquidado);
    }

    public BigDecimal getValorPago() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorPago);
    }

    public BigDecimal getValorDeducaoInicial() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorDeducaoInicial);
    }

    public BigDecimal getValorDeducao() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorDeducao);
    }

    public BigDecimal getValorRealizadoLiquido() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorRealizadoLiquido);
    }

    public BigDecimal getValorLancado() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorLancado);
    }

    @Generated
    public ReceitaDTO() {
    }

    @Generated
    public String getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getReceita() {
        return this.receita;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getFonteRecurso() {
        return this.fonteRecurso;
    }

    @Generated
    public String getFonteRecursoRateio() {
        return this.fonteRecursoRateio;
    }

    @Generated
    public String getDescricaoFonte() {
        return this.descricaoFonte;
    }

    @Generated
    public Integer getIdTipoOperacaoReceita() {
        return this.idTipoOperacaoReceita;
    }

    @Generated
    public Long getNivel() {
        return this.nivel;
    }

    @Generated
    public Long getInicio() {
        return this.inicio;
    }

    @Generated
    public Long getTamanho() {
        return this.tamanho;
    }

    @Generated
    public Integer getMes() {
        return this.mes;
    }

    @Generated
    public String getAceitaMovimentacao() {
        return this.aceitaMovimentacao;
    }

    @Generated
    public BigDecimal getValorPrevisto() {
        return this.valorPrevisto;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public BigDecimal getRepasseRecebido() {
        return this.repasseRecebido;
    }

    @Generated
    public BigDecimal getRepasseConcedido() {
        return this.repasseConcedido;
    }

    @Generated
    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setFonteRecurso(String fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    @Generated
    public void setFonteRecursoRateio(String fonteRecursoRateio) {
        this.fonteRecursoRateio = fonteRecursoRateio;
    }

    @Generated
    public void setDescricaoFonte(String descricaoFonte) {
        this.descricaoFonte = descricaoFonte;
    }

    @Generated
    public void setIdTipoOperacaoReceita(Integer idTipoOperacaoReceita) {
        this.idTipoOperacaoReceita = idTipoOperacaoReceita;
    }

    @Generated
    public void setNivel(Long nivel) {
        this.nivel = nivel;
    }

    @Generated
    public void setInicio(Long inicio) {
        this.inicio = inicio;
    }

    @Generated
    public void setTamanho(Long tamanho) {
        this.tamanho = tamanho;
    }

    @Generated
    public void setMes(Integer mes) {
        this.mes = mes;
    }

    @Generated
    public void setAceitaMovimentacao(String aceitaMovimentacao) {
        this.aceitaMovimentacao = aceitaMovimentacao;
    }

    @Generated
    public void setValorOrcado(BigDecimal valorOrcado) {
        this.valorOrcado = valorOrcado;
    }

    @Generated
    public void setValorPrevisto(BigDecimal valorPrevisto) {
        this.valorPrevisto = valorPrevisto;
    }

    @Generated
    public void setValorAtualizado(BigDecimal valorAtualizado) {
        this.valorAtualizado = valorAtualizado;
    }

    @Generated
    public void setValorArrecadado(BigDecimal valorArrecadado) {
        this.valorArrecadado = valorArrecadado;
    }

    @Generated
    public void setValorEmpenhado(BigDecimal valorEmpenhado) {
        this.valorEmpenhado = valorEmpenhado;
    }

    @Generated
    public void setValorLiquidado(BigDecimal valorLiquidado) {
        this.valorLiquidado = valorLiquidado;
    }

    @Generated
    public void setValorLancado(BigDecimal valorLancado) {
        this.valorLancado = valorLancado;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setRepasseRecebido(BigDecimal repasseRecebido) {
        this.repasseRecebido = repasseRecebido;
    }

    @Generated
    public void setRepasseConcedido(BigDecimal repasseConcedido) {
        this.repasseConcedido = repasseConcedido;
    }

    @Generated
    public void setValorDeducaoInicial(BigDecimal valorDeducaoInicial) {
        this.valorDeducaoInicial = valorDeducaoInicial;
    }

    @Generated
    public void setValorDeducao(BigDecimal valorDeducao) {
        this.valorDeducao = valorDeducao;
    }

    @Generated
    public void setValorRealizadoLiquido(BigDecimal valorRealizadoLiquido) {
        this.valorRealizadoLiquido = valorRealizadoLiquido;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceitaDTO)) {
            return false;
        }
        ReceitaDTO other = (ReceitaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$entidade = this.getEntidade();
        String other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !this$entidade.equals(other$entidade)) {
            return false;
        }
        String this$receita = this.getReceita();
        String other$receita = other.getReceita();
        if (this$receita == null ? other$receita != null : !this$receita.equals(other$receita)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$fonteRecurso = this.getFonteRecurso();
        String other$fonteRecurso = other.getFonteRecurso();
        if (this$fonteRecurso == null ? other$fonteRecurso != null : !this$fonteRecurso.equals(other$fonteRecurso)) {
            return false;
        }
        String this$fonteRecursoRateio = this.getFonteRecursoRateio();
        String other$fonteRecursoRateio = other.getFonteRecursoRateio();
        if (this$fonteRecursoRateio == null ? other$fonteRecursoRateio != null : !this$fonteRecursoRateio.equals(other$fonteRecursoRateio)) {
            return false;
        }
        String this$descricaoFonte = this.getDescricaoFonte();
        String other$descricaoFonte = other.getDescricaoFonte();
        if (this$descricaoFonte == null ? other$descricaoFonte != null : !this$descricaoFonte.equals(other$descricaoFonte)) {
            return false;
        }
        Integer this$idTipoOperacaoReceita = this.getIdTipoOperacaoReceita();
        Integer other$idTipoOperacaoReceita = other.getIdTipoOperacaoReceita();
        if (this$idTipoOperacaoReceita == null ? other$idTipoOperacaoReceita != null : !((Object)this$idTipoOperacaoReceita).equals(other$idTipoOperacaoReceita)) {
            return false;
        }
        Long this$nivel = this.getNivel();
        Long other$nivel = other.getNivel();
        if (this$nivel == null ? other$nivel != null : !((Object)this$nivel).equals(other$nivel)) {
            return false;
        }
        Long this$inicio = this.getInicio();
        Long other$inicio = other.getInicio();
        if (this$inicio == null ? other$inicio != null : !((Object)this$inicio).equals(other$inicio)) {
            return false;
        }
        Long this$tamanho = this.getTamanho();
        Long other$tamanho = other.getTamanho();
        if (this$tamanho == null ? other$tamanho != null : !((Object)this$tamanho).equals(other$tamanho)) {
            return false;
        }
        Integer this$mes = this.getMes();
        Integer other$mes = other.getMes();
        if (this$mes == null ? other$mes != null : !((Object)this$mes).equals(other$mes)) {
            return false;
        }
        String this$aceitaMovimentacao = this.getAceitaMovimentacao();
        String other$aceitaMovimentacao = other.getAceitaMovimentacao();
        if (this$aceitaMovimentacao == null ? other$aceitaMovimentacao != null : !this$aceitaMovimentacao.equals(other$aceitaMovimentacao)) {
            return false;
        }
        BigDecimal this$valorOrcado = this.getValorOrcado();
        BigDecimal other$valorOrcado = other.getValorOrcado();
        if (this$valorOrcado == null ? other$valorOrcado != null : !((Object)this$valorOrcado).equals(other$valorOrcado)) {
            return false;
        }
        BigDecimal this$valorPrevisto = this.getValorPrevisto();
        BigDecimal other$valorPrevisto = other.getValorPrevisto();
        if (this$valorPrevisto == null ? other$valorPrevisto != null : !((Object)this$valorPrevisto).equals(other$valorPrevisto)) {
            return false;
        }
        BigDecimal this$valorAtualizado = this.getValorAtualizado();
        BigDecimal other$valorAtualizado = other.getValorAtualizado();
        if (this$valorAtualizado == null ? other$valorAtualizado != null : !((Object)this$valorAtualizado).equals(other$valorAtualizado)) {
            return false;
        }
        BigDecimal this$valorArrecadado = this.getValorArrecadado();
        BigDecimal other$valorArrecadado = other.getValorArrecadado();
        if (this$valorArrecadado == null ? other$valorArrecadado != null : !((Object)this$valorArrecadado).equals(other$valorArrecadado)) {
            return false;
        }
        BigDecimal this$valorEmpenhado = this.getValorEmpenhado();
        BigDecimal other$valorEmpenhado = other.getValorEmpenhado();
        if (this$valorEmpenhado == null ? other$valorEmpenhado != null : !((Object)this$valorEmpenhado).equals(other$valorEmpenhado)) {
            return false;
        }
        BigDecimal this$valorLiquidado = this.getValorLiquidado();
        BigDecimal other$valorLiquidado = other.getValorLiquidado();
        if (this$valorLiquidado == null ? other$valorLiquidado != null : !((Object)this$valorLiquidado).equals(other$valorLiquidado)) {
            return false;
        }
        BigDecimal this$valorLancado = this.getValorLancado();
        BigDecimal other$valorLancado = other.getValorLancado();
        if (this$valorLancado == null ? other$valorLancado != null : !((Object)this$valorLancado).equals(other$valorLancado)) {
            return false;
        }
        BigDecimal this$valorPago = this.getValorPago();
        BigDecimal other$valorPago = other.getValorPago();
        if (this$valorPago == null ? other$valorPago != null : !((Object)this$valorPago).equals(other$valorPago)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        BigDecimal this$repasseRecebido = this.getRepasseRecebido();
        BigDecimal other$repasseRecebido = other.getRepasseRecebido();
        if (this$repasseRecebido == null ? other$repasseRecebido != null : !((Object)this$repasseRecebido).equals(other$repasseRecebido)) {
            return false;
        }
        BigDecimal this$repasseConcedido = this.getRepasseConcedido();
        BigDecimal other$repasseConcedido = other.getRepasseConcedido();
        if (this$repasseConcedido == null ? other$repasseConcedido != null : !((Object)this$repasseConcedido).equals(other$repasseConcedido)) {
            return false;
        }
        BigDecimal this$valorDeducaoInicial = this.getValorDeducaoInicial();
        BigDecimal other$valorDeducaoInicial = other.getValorDeducaoInicial();
        if (this$valorDeducaoInicial == null ? other$valorDeducaoInicial != null : !((Object)this$valorDeducaoInicial).equals(other$valorDeducaoInicial)) {
            return false;
        }
        BigDecimal this$valorDeducao = this.getValorDeducao();
        BigDecimal other$valorDeducao = other.getValorDeducao();
        if (this$valorDeducao == null ? other$valorDeducao != null : !((Object)this$valorDeducao).equals(other$valorDeducao)) {
            return false;
        }
        BigDecimal this$valorRealizadoLiquido = this.getValorRealizadoLiquido();
        BigDecimal other$valorRealizadoLiquido = other.getValorRealizadoLiquido();
        return !(this$valorRealizadoLiquido == null ? other$valorRealizadoLiquido != null : !((Object)this$valorRealizadoLiquido).equals(other$valorRealizadoLiquido));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReceitaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : $entidade.hashCode());
        String $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : $receita.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $fonteRecurso = this.getFonteRecurso();
        result = result * 59 + ($fonteRecurso == null ? 43 : $fonteRecurso.hashCode());
        String $fonteRecursoRateio = this.getFonteRecursoRateio();
        result = result * 59 + ($fonteRecursoRateio == null ? 43 : $fonteRecursoRateio.hashCode());
        String $descricaoFonte = this.getDescricaoFonte();
        result = result * 59 + ($descricaoFonte == null ? 43 : $descricaoFonte.hashCode());
        Integer $idTipoOperacaoReceita = this.getIdTipoOperacaoReceita();
        result = result * 59 + ($idTipoOperacaoReceita == null ? 43 : ((Object)$idTipoOperacaoReceita).hashCode());
        Long $nivel = this.getNivel();
        result = result * 59 + ($nivel == null ? 43 : ((Object)$nivel).hashCode());
        Long $inicio = this.getInicio();
        result = result * 59 + ($inicio == null ? 43 : ((Object)$inicio).hashCode());
        Long $tamanho = this.getTamanho();
        result = result * 59 + ($tamanho == null ? 43 : ((Object)$tamanho).hashCode());
        Integer $mes = this.getMes();
        result = result * 59 + ($mes == null ? 43 : ((Object)$mes).hashCode());
        String $aceitaMovimentacao = this.getAceitaMovimentacao();
        result = result * 59 + ($aceitaMovimentacao == null ? 43 : $aceitaMovimentacao.hashCode());
        BigDecimal $valorOrcado = this.getValorOrcado();
        result = result * 59 + ($valorOrcado == null ? 43 : ((Object)$valorOrcado).hashCode());
        BigDecimal $valorPrevisto = this.getValorPrevisto();
        result = result * 59 + ($valorPrevisto == null ? 43 : ((Object)$valorPrevisto).hashCode());
        BigDecimal $valorAtualizado = this.getValorAtualizado();
        result = result * 59 + ($valorAtualizado == null ? 43 : ((Object)$valorAtualizado).hashCode());
        BigDecimal $valorArrecadado = this.getValorArrecadado();
        result = result * 59 + ($valorArrecadado == null ? 43 : ((Object)$valorArrecadado).hashCode());
        BigDecimal $valorEmpenhado = this.getValorEmpenhado();
        result = result * 59 + ($valorEmpenhado == null ? 43 : ((Object)$valorEmpenhado).hashCode());
        BigDecimal $valorLiquidado = this.getValorLiquidado();
        result = result * 59 + ($valorLiquidado == null ? 43 : ((Object)$valorLiquidado).hashCode());
        BigDecimal $valorLancado = this.getValorLancado();
        result = result * 59 + ($valorLancado == null ? 43 : ((Object)$valorLancado).hashCode());
        BigDecimal $valorPago = this.getValorPago();
        result = result * 59 + ($valorPago == null ? 43 : ((Object)$valorPago).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        BigDecimal $repasseRecebido = this.getRepasseRecebido();
        result = result * 59 + ($repasseRecebido == null ? 43 : ((Object)$repasseRecebido).hashCode());
        BigDecimal $repasseConcedido = this.getRepasseConcedido();
        result = result * 59 + ($repasseConcedido == null ? 43 : ((Object)$repasseConcedido).hashCode());
        BigDecimal $valorDeducaoInicial = this.getValorDeducaoInicial();
        result = result * 59 + ($valorDeducaoInicial == null ? 43 : ((Object)$valorDeducaoInicial).hashCode());
        BigDecimal $valorDeducao = this.getValorDeducao();
        result = result * 59 + ($valorDeducao == null ? 43 : ((Object)$valorDeducao).hashCode());
        BigDecimal $valorRealizadoLiquido = this.getValorRealizadoLiquido();
        result = result * 59 + ($valorRealizadoLiquido == null ? 43 : ((Object)$valorRealizadoLiquido).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReceitaDTO(entidade=" + this.getEntidade() + ", receita=" + this.getReceita() + ", descricao=" + this.getDescricao() + ", fonteRecurso=" + this.getFonteRecurso() + ", fonteRecursoRateio=" + this.getFonteRecursoRateio() + ", descricaoFonte=" + this.getDescricaoFonte() + ", idTipoOperacaoReceita=" + this.getIdTipoOperacaoReceita() + ", nivel=" + this.getNivel() + ", inicio=" + this.getInicio() + ", tamanho=" + this.getTamanho() + ", mes=" + this.getMes() + ", aceitaMovimentacao=" + this.getAceitaMovimentacao() + ", valorOrcado=" + this.getValorOrcado() + ", valorPrevisto=" + this.getValorPrevisto() + ", valorAtualizado=" + this.getValorAtualizado() + ", valorArrecadado=" + this.getValorArrecadado() + ", valorEmpenhado=" + this.getValorEmpenhado() + ", valorLiquidado=" + this.getValorLiquidado() + ", valorLancado=" + this.getValorLancado() + ", valorPago=" + this.getValorPago() + ", data=" + this.getData() + ", repasseRecebido=" + this.getRepasseRecebido() + ", repasseConcedido=" + this.getRepasseConcedido() + ", valorDeducaoInicial=" + this.getValorDeducaoInicial() + ", valorDeducao=" + this.getValorDeducao() + ", valorRealizadoLiquido=" + this.getValorRealizadoLiquido() + ")";
    }
}

