SELECT 
    coalesce( SUM( TDPR.VALOR), 0) AS VALOR
FROM ${db.aise.schema}.TRIBDEBITOPARCELARECEITA TDPR
    LEFT OUTER JOIN ${db.aise.schema}.TRIBDEBITOPARCELA TDP
        ON TDP.ENTIDADE = TDPR.ENTIDADE
        AND TDP.EXERCICIO = TDPR.EXERCICIO
        AND TDP.TIPOCADASTRO = TDPR.TIPOCADASTRO
        AND TDP.CADASTROGERAL = TDPR.CADASTROGERAL
        AND TDP.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO
        AND TDP.SUBDIVIDA = TDPR.SUBDIVIDA
        AND TDP.PARCELA = TDPR.PARCELA
    LEFT OUTER JOIN ${db.aise.schema}.TRIBSITUACAOPARCELA TSP
       ON TSP.SITUACAOPARCELA = TDP.SITUACAODEBITO
    LEFT OUTER JOIN ${db.aise.schema}.TRIBTIPOSITUACAOPARCELA TTSP
       ON TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA
    LEFT OUTER JOIN ${db.aise.schema}.TRIBPROTESTO TPROTESTO
       ON TDP.IDPROTESTO = TPROTESTO.IDPROTESTO
    LEFT OUTER JOIN ${db.aise.schema}.TRIBCADASTROGERAL CG
        ON TDP.TIPOCADASTRO = CG.TIPOCADASTRO
        AND TDP.CADASTROGERAL = CG.CADASTROGERAL
    LEFT OUTER JOIN ${db.aise.schema}.PESSOA P
       ON P.PESSOA = CG.PESSOA
WHERE TDP.SITUACAOLEGAL IN (1,2)
    AND TTSP.TIPO = 'A'
$[FILTRO]
