/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.utils;

import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EntidadeServiceUtils {
    private final ConfiguracaoService configuracaoService;

    public EntidadeServiceUtils(ConfiguracaoService configuracaoService) {
        this.configuracaoService = configuracaoService;
    }

    public String resolveWhereSQL(Long entidade) {
        if (entidade > 0L) {
            return " = " + entidade;
        }
        Optional<ConfiguracaoInterface> configuracao = Optional.ofNullable(this.configuracaoService.getConfiguracao());
        return configuracao.map(configuracaoInterface -> " NOT IN (" + configuracaoInterface.getNaoMostrarEntidade() + ")").orElse("");
    }

    public List<Long> idsEntidadesNaoHabilitadasPortal() {
        Optional<ConfiguracaoInterface> configuracao = Optional.ofNullable(this.configuracaoService.getConfiguracao());
        if (configuracao.isPresent() && !StringUtils.isEmpty((String)configuracao.get().getNaoMostrarEntidade())) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (String s : configuracao.get().getNaoMostrarEntidade().split(",")) {
                String trim = s.trim();
                Long parseLong = Long.parseLong(trim);
                list.add(parseLong);
            }
            return list;
        }
        return new ArrayList<Long>();
    }

    public boolean isHabilitadoPortal(Long entidade) {
        return this.idsEntidadesNaoHabilitadasPortal().stream().filter(id -> id.equals(entidade)).count() == 0L;
    }
}

