/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.DashboardFeignClient;
import br.com.elotech.contabilidade.client.EmpenhoFeignClient;
import br.com.elotech.contabilidade.client.params.EmpenhoParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.ReceitaXDespesaService;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ReceitaXDespesaOxyService
implements ReceitaXDespesaService {
    private static final String SEARCH_EMPENHO_COVID = "covid==true";
    private final DashboardFeignClient dashboardFeignClient;
    private final EmpenhoFeignClient empenhoFeignClient;

    public List<ReceitaDTO> findReceitasEmpenhadosPorMes(FindReceitaParams params) {
        return this.dashboardFeignClient.getGraficoArrecadacaoDespesa(params.getEntidade(), params.getExercicio(), Boolean.TRUE).stream().map(ReceitaDTO::ofArrecadaoDespesaCovidOxy).collect(Collectors.toList());
    }

    public BigDecimal getValorEmpenhadoAnual(FindReceitaParams params) {
        return this.empenhoFeignClient.getTotal(SEARCH_EMPENHO_COVID, EmpenhoParams.builder().isCovid(Boolean.TRUE).build()).getMovimentoAtePeriodo().getSaldoEmpenhado();
    }

    @Generated
    public ReceitaXDespesaOxyService(DashboardFeignClient dashboardFeignClient, EmpenhoFeignClient empenhoFeignClient) {
        this.dashboardFeignClient = dashboardFeignClient;
        this.empenhoFeignClient = empenhoFeignClient;
    }
}

