/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosNaturezaDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import br.com.elotech.portaltransparencia.contabportal.service.LeisAtosService;
import br.com.elotech.portaltransparencia.contabportal.utils.LeisAtosOxyUtils;
import br.com.elotech.unico.client.LeiAtoFeignClient;
import br.com.elotech.unico.client.TipoLeiDocumentoFeignClient;
import br.com.elotech.unico.client.TipoLeiEscopoFeignClient;
import br.com.elotech.unico.client.TipoLeiNaturezaFeignClient;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class LeisAtosOxyService
implements LeisAtosService {
    private final LeiAtoFeignClient leiAtoFeignClient;
    private final TipoLeiDocumentoFeignClient leiDocumentoFeignClient;
    private final TipoLeiNaturezaFeignClient leiNaturezaFeignClient;
    private final TipoLeiEscopoFeignClient leiEscopoFeignClient;

    public Page<LeisAtosDTO> findLeisAtos(LeisAtosParams params, Pageable pageable) {
        EloPage leis = this.leiAtoFeignClient.findAll(LeisAtosOxyUtils.translateSearchToOxy((LeisAtosParams)params), LeisAtosOxyUtils.translateSortToOxy((Pageable)pageable));
        return new PageImpl(leis.getContent().stream().map(LeisAtosDTO::ofLeiUnico).collect(Collectors.toList()), pageable, leis.getTotalElements());
    }

    public LeisAtosDTO findOneLeiAto(LeisAtosParams params) {
        return params.getId().map(id -> this.leiAtoFeignClient.findOne((Long)params.getId().get()).map(LeisAtosDTO::ofLeiUnico).orElse(null)).orElse(null);
    }

    public List<LeisAtosNaturezaDTO> findLeisAtosNatureza(LeisAtosParams params) {
        return this.leiNaturezaFeignClient.findTiposNatureza().stream().map(n -> LeisAtosNaturezaDTO.builder().id(n.getId()).codigo(n.getCodigo()).descricao(n.getDescricao()).build()).collect(Collectors.toList());
    }

    public List<LeisAtosNaturezaDTO> findTiposDocumentoLegal(LeisAtosParams params) {
        return this.leiDocumentoFeignClient.findTiposDocumentoLegal().stream().map(d -> LeisAtosNaturezaDTO.builder().id(d.getId()).codigo(d.getCodigo()).descricao(d.getDescricao()).build()).collect(Collectors.toList());
    }

    public List<LeisAtosNaturezaDTO> findTiposEscopo(LeisAtosParams params) {
        return this.leiEscopoFeignClient.findTiposEscopo().stream().map(e -> LeisAtosNaturezaDTO.builder().id(e.getId()).codigo(e.getCodigo()).descricao(e.getDescricao()).build()).collect(Collectors.toList());
    }

    public ArquivoDTO findArquivoLegislacao(Long id, Long idArquivo, Long anoLei, String natureza, Long tipo, String tabela) {
        return null;
    }

    public ArquivoDTO findArquivoLegislacao(Long id, Long idArquivo, Long anoLei, String natureza, String tabela) {
        return null;
    }

    @Generated
    public LeisAtosOxyService(LeiAtoFeignClient leiAtoFeignClient, TipoLeiDocumentoFeignClient leiDocumentoFeignClient, TipoLeiNaturezaFeignClient leiNaturezaFeignClient, TipoLeiEscopoFeignClient leiEscopoFeignClient) {
        this.leiAtoFeignClient = leiAtoFeignClient;
        this.leiDocumentoFeignClient = leiDocumentoFeignClient;
        this.leiNaturezaFeignClient = leiNaturezaFeignClient;
        this.leiEscopoFeignClient = leiEscopoFeignClient;
    }
}

