/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.AnulacaoEmpenhoFeignClient;
import br.com.elotech.contabilidade.client.EmLiquidacaoFeignClient;
import br.com.elotech.contabilidade.client.EmpenhoFeignClient;
import br.com.elotech.contabilidade.client.LiquidacaoFeignClient;
import br.com.elotech.contabilidade.client.PagamentoFeignClient;
import br.com.elotech.contabilidade.client.dto.DespesaDTO;
import br.com.elotech.contabilidade.client.dto.EmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.EmpenhoItemDTO;
import br.com.elotech.contabilidade.client.dto.EmpenhoSaldoValoresDTO;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.orcamento.client.CadastrosFeignClient;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnexosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoAnulacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDocumentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoEmLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLinksDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoLiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoMovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoRetencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhosListaDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.ComprasDiretaToDTO;
import br.com.elotech.portaltransparencia.contabportal.service.EmpenhoService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.utils.EmpenhoOxyUtils;
import br.com.elotech.portaltransparencia.report.EmpenhoReport;
import br.com.elotech.portaltransparencia.report.ReportUtils;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class EmpenhoOxyService
implements EmpenhoService {
    private static final int NIVEL_DESDOBRAMENTO = 5;
    private static final int NIVEL_SUBDESDOBRAMENTO = 6;
    private static final String TIPO_ANEXO_LIQ = "LIQUIDA\u00c7\u00c3O";
    private final EmpenhoFeignClient empenhoFeignClient;
    private final AnulacaoEmpenhoFeignClient anulacaoEmpenhoFeignClient;
    private final LiquidacaoFeignClient liquidacaoFeignClient;
    private final PagamentoFeignClient pagamentoFeignClient;
    private final CadastrosFeignClient orcamentoFeignClient;
    private final EmLiquidacaoFeignClient emLiquidacaoFeignClient;
    private final EntidadeContabilidadeService entidadeService;

    public Page<EmpenhosListaDTO> getEmpenhosSearch(Pageable pageable, EmpenhoParams params) {
        EloPage empenhos = this.findEmpenhosOxy(pageable, params);
        return new PageImpl(empenhos.getContent().stream().map(EmpenhosListaDTO::new).collect(Collectors.toList()), pageable, empenhos.getTotalElements());
    }

    public EmpenhosListaDTO getEmpenhosTotal(EmpenhoParams params) {
        if (!Strings.isNullOrEmpty((String)params.getSearch())) {
            EmpenhoSaldoValoresDTO total = this.empenhoFeignClient.getTotal(EmpenhoOxyUtils.translateSearchToOxy((EmpenhoParams)params), EmpenhoOxyUtils.translateParams((EmpenhoParams)params)).getMovimentoAtePeriodo();
            return new EmpenhosListaDTO(total.getEmpenhado(), total.getSaldoAnulado(), total.getSaldoLiquidacao(), total.getSaldoRetido(), total.getSaldoPago(), total.getEmpenhoPagar());
        }
        return new EmpenhosListaDTO(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO getEmpenhoDetalhe(EmpenhoParams params) {
        EmpenhoDTO empenho = this.empenhoFeignClient.findByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho());
        br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO empenhoDTO = new br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO(empenho);
        List despesas = this.orcamentoFeignClient.findDespesasTCEDTO(EmpenhoOxyUtils.buildSearchDespesa((DespesaDTO)empenho.getDespesa()), params.getEntidade(), params.getExercicio());
        empenhoDTO.setDescricaoDesdobramento(EmpenhoOxyUtils.getDescricaoByNivel((List)despesas, (String)empenhoDTO.getDesdobraDesp(), (int)5));
        empenhoDTO.setDescricaoSubDesdobramento(EmpenhoOxyUtils.getDescricaoByNivel((List)despesas, (String)empenhoDTO.getSubDesdobramento(), (int)6));
        return empenhoDTO;
    }

    public List<EmpenhoItensDTO> getEmpenhoDetalheItens(EmpenhoParams params) {
        return this.empenhoFeignClient.findByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).getItensEmpenho().stream().map(EmpenhoItensDTO::new).collect(Collectors.toList());
    }

    public List<EmpenhoAnulacaoDTO> getEmpenhoDetalheAnulacao(EmpenhoParams params) {
        return this.anulacaoEmpenhoFeignClient.findAllAnulacoesByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).stream().map(EmpenhoAnulacaoDTO::new).collect(Collectors.toList());
    }

    public List<EmpenhoLiquidacaoDTO> getEmpenhoDetalheLiquidacao(EmpenhoParams params) {
        return this.liquidacaoFeignClient.findAllLiquidacoesByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).stream().map(EmpenhoLiquidacaoDTO::new).collect(Collectors.toList());
    }

    public List<EmpenhoPagamentoDTO> getEmpenhoDetalhePagamento(EmpenhoParams params) {
        return this.pagamentoFeignClient.findAllPagamentosByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).stream().map(EmpenhoPagamentoDTO::new).collect(Collectors.toList());
    }

    public List<EmpenhoRetencaoDTO> getEmpenhoDetalheRetencao(EmpenhoParams params) {
        ArrayList<EmpenhoRetencaoDTO> retencoes = new ArrayList<EmpenhoRetencaoDTO>();
        this.liquidacaoFeignClient.findAllLiquidacoesByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).forEach(l -> l.getRetencoesLiquidacao().forEach(r -> retencoes.add(new EmpenhoRetencaoDTO(r, l))));
        return retencoes;
    }

    public List<EmpenhoMovimentacaoDTO> getEmpenhoDetalheMovimentacao(EmpenhoParams params) {
        return this.empenhoFeignClient.getAllMovimentacoes(params.getEntidade(), params.getExercicio(), params.getEmpenho()).stream().map(EmpenhoMovimentacaoDTO::new).collect(Collectors.toList());
    }

    public List<EmpenhoDocumentoDTO> getEmpenhoDetalheDocumentos(EmpenhoParams params) {
        ArrayList<EmpenhoDocumentoDTO> documentos = new ArrayList<EmpenhoDocumentoDTO>();
        this.liquidacaoFeignClient.findAllLiquidacoesByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).forEach(l -> l.getDocumentos().forEach(d -> documentos.add(new EmpenhoDocumentoDTO(l, d))));
        return documentos;
    }

    public List<EmpenhoEmLiquidacaoDTO> getEmpenhoDetalheEmLiquidacao(EmpenhoParams params) {
        return this.emLiquidacaoFeignClient.findAllLiquidacoesByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).stream().map(EmpenhoEmLiquidacaoDTO::new).collect(Collectors.toList());
    }

    public byte[] gerarRelatorioPdf(EmpenhoParams params) {
        return ReportUtils.exportToPdfByJasperPrint((JasperPrint)this.gerarRelatorio(params));
    }

    private JasperPrint gerarRelatorio(EmpenhoParams params) {
        br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO empenhoDetalhe = this.getEmpenhoDetalhe(params);
        JasperReport jasperReport = ReportUtils.getJasperReportByLocation((String)"classpath:reports/nota_empenho.jasper");
        Entidade entidadeSelecionada = this.entidadeService.findOne(params.getEntidade());
        Map parameters = EmpenhoReport.getParameters((Entidade)entidadeSelecionada);
        return JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)new JRBeanCollectionDataSource(Arrays.asList(empenhoDetalhe)));
    }

    public List<EmpenhoAnexosDTO> getEmpenhoDetalheAnexos(EmpenhoParams params) {
        ArrayList<EmpenhoAnexosDTO> anexos = new ArrayList<EmpenhoAnexosDTO>();
        this.liquidacaoFeignClient.findAllLiquidacoesByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).forEach(l -> l.getAnexos().forEach(d -> anexos.add(new EmpenhoAnexosDTO(l, d, TIPO_ANEXO_LIQ))));
        return anexos;
    }

    public EmpenhoItensDTO getEmpenhoDetalheItem(EmpenhoParams params) {
        return null;
    }

    public Page<ComprasDiretaDTO> getComprasDiretaItensEmpenho(Pageable pageable, EmpenhoParams params) {
        EloPage empenhos = this.findEmpenhosOxy(pageable, params);
        List comprasDiretaDTOList = empenhos.getContent().stream().flatMap(e -> e.getItensEmpenho().stream().map(ei -> ComprasDiretaToDTO.apply((EmpenhoItemDTO)ei, (EmpenhoDTO)e))).collect(Collectors.toList());
        return new PageImpl(comprasDiretaDTOList, pageable, empenhos.getTotalElements());
    }

    public List<EmpenhoLinksDTO> getEmpenhoDetalheLinks(EmpenhoParams params) {
        ArrayList<EmpenhoLinksDTO> links = new ArrayList<EmpenhoLinksDTO>();
        this.liquidacaoFeignClient.findAllLiquidacoesByNumeroEmpenho(params.getEntidade(), params.getExercicio(), params.getEmpenho()).forEach(l -> l.getDocumentos().forEach(d -> links.add(new EmpenhoLinksDTO(l, d))));
        return links;
    }

    private EloPage<EmpenhoDTO> findEmpenhosOxy(Pageable pageable, EmpenhoParams params) {
        if (!Strings.isNullOrEmpty((String)params.getSearch())) {
            return this.empenhoFeignClient.findAllWithMovimento(EmpenhoOxyUtils.translateSearchToOxy((EmpenhoParams)params), EmpenhoOxyUtils.translateSortToOxy((Pageable)pageable), EmpenhoOxyUtils.translateParams((EmpenhoParams)params));
        }
        return new EloPage();
    }

    @Generated
    public EmpenhoOxyService(EmpenhoFeignClient empenhoFeignClient, AnulacaoEmpenhoFeignClient anulacaoEmpenhoFeignClient, LiquidacaoFeignClient liquidacaoFeignClient, PagamentoFeignClient pagamentoFeignClient, CadastrosFeignClient orcamentoFeignClient, EmLiquidacaoFeignClient emLiquidacaoFeignClient, EntidadeContabilidadeService entidadeService) {
        this.empenhoFeignClient = empenhoFeignClient;
        this.anulacaoEmpenhoFeignClient = anulacaoEmpenhoFeignClient;
        this.liquidacaoFeignClient = liquidacaoFeignClient;
        this.pagamentoFeignClient = pagamentoFeignClient;
        this.orcamentoFeignClient = orcamentoFeignClient;
        this.emLiquidacaoFeignClient = emLiquidacaoFeignClient;
        this.entidadeService = entidadeService;
    }
}

