/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.adm.compras.client.LicitacaoClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.oxy.adm.compras.client.portal.LicitacaoPortalDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AtaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CertidaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.MidiaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ParecerDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PrecoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PublicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class LicitacaoOxyRepositoryImpl
implements LicitacaoRepository {
    private final LicitacaoClient client;

    public LicitacaoOxyRepositoryImpl(LicitacaoClient client) {
        this.client = client;
    }

    public Page<LicitacaoDTO> findLicitacoes(FindLicitacaoParams params, Pageable pageable) {
        EloPage licitacoesPage = this.client.findAll(params.toComprasOxyParams(), pageable);
        List licitacoes = licitacoesPage.getContent().stream().map(LicitacaoDTO::fromLicitacaoOxy).collect(Collectors.toList());
        return new PageImpl(licitacoes, pageable, licitacoesPage.getTotalElements());
    }

    public LicitacaoDTO findLicitacao(FindLicitacaoParams params) {
        return LicitacaoDTO.fromLicitacaoOxy((LicitacaoPortalDTO)this.client.findOne(params.toComprasOxyParams()));
    }

    public List<ParecerDTO> findPareceres(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findPareceres(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(ParecerDTO::fromParecerComprasOxy).collect(Collectors.toList());
    }

    public List<CotacaoLicitacaoDTO> findCotacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findCotacoes(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(CotacaoLicitacaoDTO::fromCotacaoComprasOxy).collect(Collectors.toList());
    }

    public List<MidiaLicitacaoDTO> findMidia(FindLicitacaoParams params) {
        return this.client.findMidia(params.toComprasOxyParams()).stream().map(MidiaLicitacaoDTO::fromMidiaComprasOxy).collect(Collectors.toList());
    }

    public List<PublicacaoLicitacaoDTO> findPublicacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findPublicacoes(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(PublicacaoLicitacaoDTO::fromPublicacaoComprasOxy).collect(Collectors.toList());
    }

    public List<AtaLicitacaoDTO> findAtasRegistroPreco(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findAtasRegistroPreco(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(AtaLicitacaoDTO::fromAtaComprasOxy).collect(Collectors.toList());
    }

    public List<AtaLicitacaoDTO> findAtasLicitacao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findAtasLicitacao(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(AtaLicitacaoDTO::fromAtaComprasOxy).collect(Collectors.toList());
    }

    public List<AtaLicitacaoDTO> findAtasSessaoPregao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        throw new NotImplementedException("TO not implemented yet.");
    }

    public List<CertidaoLicitacaoDTO> findCertidoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findCertidoes(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(CertidaoLicitacaoDTO::fromCertidaoComprasOxy).collect(Collectors.toList());
    }

    public List<PrecoLicitacaoDTO> findPrecos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findPrecos(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(PrecoLicitacaoDTO::fromPrecoComprasOxy).collect(Collectors.toList());
    }

    public List<RecursoLicitacaoDTO> findRecursos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        return this.client.findRecursos(params.toComprasOxyParams(), nomeSchemaEloArquivo).stream().map(RecursoLicitacaoDTO::fromRecursosComprasOxy).collect(Collectors.toList());
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return UltimaAtualizacaoDTO.fromUltimasAtualizacoesOxy((List)this.client.findUltimaAtualizacao(params.toComprasOxyParams()));
    }
}

