/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.AjudaCustoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorAjudaCustoDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.AjudaCustoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AjudaCustoParams;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/ajuda-custo"})
public class AjudaCustoResource {
    private final AjudaCustoRepository repository;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public AjudaCustoResource(AjudaCustoRepository repository, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.repository = repository;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public Page<ServidorAjudaCustoDTO> findAjudasCusto(@RequestHeader(value="entidade") Long entidade, AjudaCustoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        return this.repository.findAjudasCusto(params, pageable);
    }

    @GetMapping(value={"/servidor"}, params={"matricula"})
    public ServidorAjudaCustoDTO findServidorAjudaCusto(@RequestHeader(value="entidade") Long entidade, AjudaCustoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        Page findAjudasCusto = this.repository.findAjudasCusto(params, pageable);
        return findAjudasCusto.getContent().stream().findFirst().orElse(null);
    }

    @GetMapping(value={"/detalhe"}, params={"matricula"})
    public Page<AjudaCustoDTO> findAjudaCusto(@RequestHeader(value="entidade") Long entidade, AjudaCustoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        return this.repository.findAjudaCusto(params, pageable);
    }

    @GetMapping(value={"/report"})
    public ModelAndView findDiariasExport(HttpServletRequest request, HttpServletResponse response, AjudaCustoParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.repository.findAjudasCusto(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Ajuda de Custo");
        reportParam.setClazzDTO(ServidorAjudaCustoDTO.class);
        reportParam.setHeaderFields("Matr\u00edcula,Nome do Servidor,Cargo");
        reportParam.setFields("matricula,nome,cargoDescricao");
        float[] fieldsPerc = new float[]{2.0f, 4.0f, 4.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 50, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

