 SELECT A.ENTIDADE,           A.EXERCICIO,
        A.EXERCICIOLICITACAO, A.TIPOLICITACAO,
        A.LICITACAO,          A.PESSOA,
        P.NOME,               
        CASE
	    	WHEN P.TIPOPESSOA = 'F'
	    	THEN '**' || SUBSTR(P.CNPJ_CPF,3,5) || '****'
	    	ELSE P.CNPJ_CPF
	    END as CNPJCPF, 
        A.DATA,               ARQ.IDARQUIVO, 
	    case when ARQ.NOMEARQUIVO is null 
	         then ELOARQ.NOME 
	         else ARQ.NOMEARQUIVO 
	    end as NOMEARQUIVO, 
	 ARQ.DATA AS DATAARQUIVO,
	 LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO
   FROM ${db.compras.schema}.CLADJUDICACAO A
   LEFT OUTER JOIN ${db.compras.schema}.CLLICITACAO B
     ON A.ENTIDADE = B.ENTIDADE
    AND A.EXERCICIOLICITACAO = B.EXERCICIO
    AND A.TIPOLICITACAO = B.TIPOLICITACAO
    AND A.LICITACAO = B.LICITACAO
   LEFT OUTER JOIN ${db.compras.schema}.PESSOA P
     ON A.PESSOA = P.PESSOA   
   LEFT OUTER JOIN ${db.compras.schema}.ARQUIVO ARQ
     ON A.IDARQUIVO = ARQ.ID 
   LEFT OUTER JOIN schema_eloarquivo.ARQUIVO ELOARQ 
     ON ELOARQ.ID = ARQ.IDARQUIVO 
   LEFT OUTER JOIN schema_eloarquivo.ARQUIVO_CONTENT AC 
     ON AC.ID = ARQ.IDARQUIVO 
  WHERE A.ENTIDADE =  :entidade 
    AND A.EXERCICIOLICITACAO =  :exercicio 
    AND A.TIPOLICITACAO =  :tipoLicitacao 
    AND A.LICITACAO =  :licitacao 
    AND EXISTS (
    SELECT ANALIS.ENTIDADE FROM ${db.compras.schema}.CLANALISEVENCEDOR ANALIS
     WHERE A.ENTIDADE = ANALIS.ENTIDADE
       AND A.EXERCICIOLICITACAO = ANALIS.EXERCICIOLICITACAO
       AND A.TIPOLICITACAO = ANALIS.TIPOLICITACAO
       AND A.LICITACAO = ANALIS.LICITACAO
       AND A.PESSOA = ANALIS.PESSOA
       AND ANALIS.VENCEDOR = 'S')