/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.contabportal.domain.LinkUtil;
import br.com.elotech.portaltransparencia.contabportal.repository.LinkUtilRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LinkUtilParams;
import br.com.elotech.portaltransparencia.contabportal.service.LinkUtilService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinkUtilServiceImpl
implements LinkUtilService {
    private final LinkUtilRepository repository;
    private final PortalParametroService portalParametroService;

    @Autowired
    public LinkUtilServiceImpl(LinkUtilRepository repository, PortalParametroService portalParametroService) {
        this.repository = repository;
        this.portalParametroService = portalParametroService;
    }

    public List<LinkUtil> findLinksUteis(LinkUtilParams params) {
        if (Objects.isNull(params.getTipo())) {
            return this.repository.findByEntidadeOrderByDescricao(params.getEntidade());
        }
        return this.repository.findByEntidadeAndIdTipoOrderByDescricao(params.getEntidade(), params.getTipo());
    }

    public List<LinkUtil> findLinksUteisAtivos(LinkUtilParams params) {
        if (this.validarParametro(params).booleanValue()) {
            if (Objects.isNull(params.getTipo())) {
                return this.repository.findByEntidadeAndAtivoOrderByDescricao(params.getEntidade(), Boolean.TRUE);
            }
            return this.repository.findByEntidadeAndAtivoAndIdTipoOrderByDescricao(params.getEntidade(), Boolean.TRUE, params.getTipo());
        }
        return new ArrayList<LinkUtil>();
    }

    public LinkUtil findLink(Long id) {
        return (LinkUtil)this.repository.findOne((Object)id);
    }

    public LinkUtil saveLink(LinkUtil link) {
        if (Objects.isNull(link.getIdTipo())) {
            link.setIdTipo(Long.valueOf(1L));
        }
        return (LinkUtil)this.repository.save((Object)link);
    }

    public void deleteLink(LinkUtil link) {
        this.repository.delete((Object)link);
    }

    private Boolean validarParametro(LinkUtilParams params) {
        String mostraLinksUteis = this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), Parametros.PARAM_LINKS_UTEIS);
        return "S".equals(mostraLinksUteis);
    }
}

