/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.FuncaoGratificadaDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.FuncaoGratificadaRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FuncaoGratificadaParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class FuncaoGratificadaRepositoryImpl
implements FuncaoGratificadaRepository {
    private static final String FUNCAO_GRATIFICADA_SQL = "db/sql/aise/funcoes-gratificadas.sql";
    private final EntidadeAiseService entidadeAiseService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FuncaoGratificadaRepositoryImpl.class);
    private final DatasourceWrapper datasourceWrapper;

    public FuncaoGratificadaRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<FuncaoGratificadaDTO> loadFuncoesGratificadas(FuncaoGratificadaParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)FUNCAO_GRATIFICADA_SQL));
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)"ORDER BY DESCRICAO");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        LOGGER.debug(sql.toString());
        LOGGER.debug(params.toString());
        List funcoes = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(FuncaoGratificadaDTO.class));
        return new PageImpl(funcoes, pageable, this.getQuantidadeFuncaoGratificada(sql.toString(), parameter).longValue());
    }

    private Long getQuantidadeFuncaoGratificada(String query, MapSqlParameterSource parameter) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (");
        queryCount.append(query);
        queryCount.append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
    }
}

