 SELECT TB1.ENTIDADE,                                               
        TB1.EXERCICIO,                                             
        TB1.VALORPLANEJADO,                                             
        TB1.VALORPLANEJADOATUALIZADO,                               
        TB1.VALOREXECUTADO,                 
        TB1.PROJETO,         
        TB1.UNIDADE,    
        TB1.FUNCAO,    
        TB1.PROGRAMA,
        TB1.DESCRICAOPROJETO,                                              
        ACAOPPA.METAFISICAPREVISTA, 
        ACAOPPA.NUMEROREALIZADO, 
        MAX(ACAOPPA.RESULTADOOBTIDO) OVER (PARTITION BY TB1.PROJETO) RESULTADOOBTIDO, 
        MAX(ACAOPPA.DSUNIDADEMEDIDA) OVER (PARTITION BY TB1.PROJETO) UNIDADEMEDIDA    
   FROM (                                            
         SELECT A.ENTIDADE,                          
                A.EXERCICIO,                         
                SUM(A.VALORPREVISTO) VALORPLANEJADO, 
                SUM(A.VALORPREVISTO + B.VALORSUPLEMENTACAO - B.VALORREDUCAO - B.VALORESTSUPLEMENTACAO + B.VALORESTREDUCAO) VALORPLANEJADOATUALIZADO, 
                SUM(B.VALOREMPENHO - B.VALORANULACAOEMPENHO + B.VALORESTANULACAOEMPENHO) VALOREXECUTADO,                          
                CAST(SUBSTR(A.PROGRAMATICA, 15, 4) AS VARCHAR(10)) PROJETO,
                CAST(SUBSTR(A.PROGRAMATICA, 1,  5) AS VARCHAR(10)) UNIDADE, 
                CAST(SUBSTR(A.PROGRAMATICA, 6,  2) AS VARCHAR(10)) FUNCAO,
                CAST(SUBSTR(A.PROGRAMATICA, 11, 4) AS VARCHAR(10)) PROGRAMA, 
                (SELECT DESCRICAO                
                   FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA
                  WHERE ENTIDADE  = A.ENTIDADE   
                    AND EXERCICIO = A.EXERCICIO  
                    AND ORDEM     = 6            
                    AND CODIGO    = SUBSTR(A.PROGRAMATICA, 15, 4)) DESCRICAOPROJETO 
           FROM ${db.contabilidade.schema}.DESPESA A
           JOIN (SELECT DESPESA.ENTIDADE, DESPESA.EXERCICIO, DESPESA.PROGRAMATICA, DESPESA.FONTERECURSO, 
                        SUM(DESPESAMENSAL.VALORSUPLEMENTACAO) AS VALORSUPLEMENTACAO,          
                        SUM(DESPESAMENSAL.VALORREDUCAO) AS VALORREDUCAO,                      
                        SUM(DESPESAMENSAL.VALOREMPENHO) AS VALOREMPENHO,                      
                        SUM(DESPESAMENSAL.VALORANULACAOEMPENHO) AS VALORANULACAOEMPENHO,      
                        SUM(DESPESAMENSAL.VALORESTSUPLEMENTACAO) AS VALORESTSUPLEMENTACAO,    
                        SUM(DESPESAMENSAL.VALORESTREDUCAO) AS VALORESTREDUCAO,                
                        SUM(DESPESAMENSAL.VALORESTANULACAOEMPENHO) AS VALORESTANULACAOEMPENHO 
                   FROM ${db.contabilidade.schema}.DESPESAMENSAL DESPESAMENSAL
                   JOIN ${db.contabilidade.schema}.DESPESA DESPESA
                     ON DESPESA.ENTIDADE     = DESPESAMENSAL.ENTIDADE                   
                    AND DESPESA.EXERCICIO    = DESPESAMENSAL.EXERCICIO                  
                    AND DESPESA.PROGRAMATICA = DESPESAMENSAL.PROGRAMATICA               
                    AND DESPESA.FONTERECURSO = DESPESAMENSAL.FONTERECURSO               
                  WHERE DESPESA.EXERCICIO BETWEEN :exercicio - 2 AND :exercicio
                    AND DESPESA.NIVEL = 6                                               
                  GROUP BY DESPESA.ENTIDADE, DESPESA.EXERCICIO, DESPESA.PROGRAMATICA, DESPESA.FONTERECURSO) B 
             ON A.ENTIDADE     = B.ENTIDADE                                                
            AND A.EXERCICIO    = B.EXERCICIO                                               
            AND A.PROGRAMATICA = B.PROGRAMATICA                                            
            AND A.FONTERECURSO = B.FONTERECURSO                                            
          WHERE A.EXERCICIO BETWEEN :exercicio - 2 AND :exercicio
            AND A.NIVEL = 6                                                                
            AND SUBSTR(A.PROGRAMATICA, 15, 4) 
             IN (SELECT C.PROJETOATIVIDADE          
                   FROM ${db.contabilidade.schema}.ORCPPA A
                   JOIN ${db.contabilidade.schema}.ORCPPAVALOR B
                     ON A.ENTIDADE   = B.ENTIDADE   
                    AND A.EXERCICIO  = B.EXERCICIO  
                    AND A.COD_ORCPPA = B.COD_ORCPPA 
                   JOIN ${db.contabilidade.schema}.ORCACAO C
                     ON B.ENTIDADE   = C.ENTIDADE   
                    AND B.EXERCICIO = C.EXERCICIO   
                    AND B.IDORCACAO = C.ID          
                  WHERE B.EXERCICIO = :exercicio    
                    AND A.TIPOPLANO = 1)            
            $[filtros]
          GROUP BY A.ENTIDADE, A.EXERCICIO, A.PROGRAMATICA 
        ) TB1 
   LEFT JOIN (SELECT ORCPPAAVALIACAOACAO.ENTIDADE, ORCPPAAVALIACAOACAO.EXERCICIO, 
                     ORCPPAAVALIACAOACAO.VALORREALIZADO,                          
                     ORCPPAAVALIACAOACAO.NUMEROREALIZADO, ORCPPAAVALIACAOACAO.RESULTADOOBTIDO, 
                     ORCACAO.PROJETOATIVIDADE,                                                 
                     CASE WHEN ORCPPAAVALIACAOACAO.EXERCICIO = ORCPPAVALOR.ANO1 THEN ORCPPAVALOR.METAFISICA1 
                          WHEN ORCPPAAVALIACAOACAO.EXERCICIO = ORCPPAVALOR.ANO2 THEN ORCPPAVALOR.METAFISICA2 
                          WHEN ORCPPAAVALIACAOACAO.EXERCICIO = ORCPPAVALOR.ANO3 THEN ORCPPAVALOR.METAFISICA3 
                          WHEN ORCPPAAVALIACAOACAO.EXERCICIO = ORCPPAVALOR.ANO4 THEN ORCPPAVALOR.METAFISICA4 
                          ELSE 0                              
                     END METAFISICAPREVISTA,                  
                     TIPOUNIDADEMEDIDA.DSUNIDADEMEDIDA        
                FROM ${db.contabilidade.schema}.ORCPPAAVALIACAOACAO ORCPPAAVALIACAOACAO
                JOIN ${db.contabilidade.schema}.ORCACAO ORCACAO
                  ON ORCPPAAVALIACAOACAO.ENTIDADE  = ORCACAO.ENTIDADE    
                 AND ORCPPAAVALIACAOACAO.EXERCICIO = ORCACAO.EXERCICIO   
                 AND ORCPPAAVALIACAOACAO.IDORCACAO = ORCACAO.ID          
                JOIN ${db.contabilidade.schema}.ORCPPAVALOR ORCPPAVALOR
                  ON ORCACAO.ENTIDADE  = ORCPPAVALOR.ENTIDADE            
                 AND ORCACAO.EXERCICIO = ORCPPAVALOR.EXERCICIO           
                 AND ORCACAO.ID        = ORCPPAVALOR.IDORCACAO           
                JOIN (SELECT ENTIDADE, EXERCICIO, COD_ORCPPA             
                        FROM ${db.contabilidade.schema}.ORCPPA A
                       WHERE VERSAO = (SELECT MAX(VERSAO) FROM ${db.contabilidade.schema}.ORCPPA WHERE ENTIDADE = A.ENTIDADE AND EXERCICIO = A.EXERCICIO)
                       GROUP BY ENTIDADE, EXERCICIO, COD_ORCPPA) ORCPPA  
                  ON ORCPPAVALOR.ENTIDADE   = ORCPPA.ENTIDADE            
                 AND ORCPPAVALOR.EXERCICIO  = ORCPPA.EXERCICIO           
                 AND ORCPPAVALOR.COD_ORCPPA = ORCPPA.COD_ORCPPA          
                LEFT JOIN ${db.contabilidade.schema}.TIPOUNIDADEMEDIDA TIPOUNIDADEMEDIDA
                  ON ORCACAO.IDUNIDADEMEDIDA = TIPOUNIDADEMEDIDA.CODIGO  
               WHERE ORCACAO.TIPOPLANO = 1                               
             ) ACAOPPA                                                   
       ON TB1.ENTIDADE  = ACAOPPA.ENTIDADE                               
      AND TB1.EXERCICIO = ACAOPPA.EXERCICIO                              
      AND TB1.PROJETO = ACAOPPA.PROJETOATIVIDADE
