/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.contabilidade.client.ProgramaticaPortalFeignClient;
import br.com.elotech.contabilidade.client.dto.FuncaoDTO;
import br.com.elotech.contabilidade.client.dto.ProgramaDTO;
import br.com.elotech.contabilidade.client.dto.ProjetoAtividadeDTO;
import br.com.elotech.contabilidade.client.dto.SubfuncaoDTO;
import br.com.elotech.contabilidade.client.dto.UnidadeDTO;
import br.com.elotech.orcamento.client.dto.FonteRecursoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ProgramaticaFilterDTO;
import br.com.elotech.portaltransparencia.contabportal.service.ProgramaticaService;
import br.com.elotech.portaltransparencia.web.rest.params.ProgramaticaParams;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ProgramaticaOxyServiceImpl
implements ProgramaticaService {
    private ProgramaticaPortalFeignClient feignClient;

    public List<ProgramaticaFilterDTO> findOrgao(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaOrgao(params.getEntidade(), params.getExercicio()).stream().sorted(Comparator.comparing(UnidadeDTO::getCodigo)).map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    public List<ProgramaticaFilterDTO> findUnidade(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaUnidade(params.getEntidade(), params.getExercicio()).stream().sorted(Comparator.comparing(UnidadeDTO::getCodigo)).map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    public List<ProgramaticaFilterDTO> findFuncao(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaFuncao(params.getEntidade(), params.getExercicio()).stream().sorted(Comparator.comparing(FuncaoDTO::getCodigo)).map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    public List<ProgramaticaFilterDTO> findSubFuncao(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaSubfuncao(params.getEntidade(), params.getExercicio()).stream().sorted(Comparator.comparing(SubfuncaoDTO::getCodigo)).map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    public List<ProgramaticaFilterDTO> findPrograma(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaPrograma(params.getEntidade(), params.getExercicio()).stream().sorted(Comparator.comparing(ProgramaDTO::getCodigo)).map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    public List<ProgramaticaFilterDTO> findProjeto(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaProjeto(params.getEntidade(), params.getExercicio()).stream().sorted(Comparator.comparing(ProjetoAtividadeDTO::getCodigo)).map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    public List<ProgramaticaFilterDTO> findElemento(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaElementoDespesa(params.getEntidade(), params.getExercicio()).stream().map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    public List<ProgramaticaFilterDTO> findDesdobramento(ProgramaticaParams params) {
        return List.of();
    }

    public List<ProgramaticaFilterDTO> findSubDesdobramento(ProgramaticaParams params) {
        return List.of();
    }

    public List<ProgramaticaFilterDTO> findFonteRecurso(ProgramaticaParams params) {
        return this.feignClient.findProgramaticaFonte(params.getEntidade(), params.getExercicio()).stream().sorted(Comparator.comparing(FonteRecursoDTO::getCodigo)).map(obj -> new ProgramaticaFilterDTO(obj.getCodigo(), obj.getDescricao())).collect(Collectors.toList());
    }

    @Generated
    public ProgramaticaOxyServiceImpl(ProgramaticaPortalFeignClient feignClient) {
        this.feignClient = feignClient;
    }
}

