/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.EstagiarioRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.aiseportal.service.EstagiarioService;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoAiseOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.folhaportal.service.EstagiarioServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class EstagiarioServiceImpl
implements EstagiarioService {
    private final EstagiarioRepository estagiarioRepository;
    private final PortalParametroService portalParametroService;
    private final IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService;
    private final EstagiarioServiceOxy serviceOxy;
    private final EntidadeAiseService entidadeAiseService;

    public Page<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
            return this.serviceOxy.loadEstagiarios(params, pageable);
        }
        if (this.utilizaWebService()) {
            return new PageImpl(new ArrayList());
        }
        return this.estagiarioRepository.loadEstagiarios(params, pageable);
    }

    public Optional<EstagiarioDTO> loadEstagiario(ServidorParams params) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
            return this.serviceOxy.loadEstagiario(params);
        }
        Optional estagiario = this.estagiarioRepository.loadEstagiario(params);
        estagiario.ifPresent(e -> e.setDadosFinanceiros(this.estagiarioRepository.loadDadosFinanceiros(params)));
        return estagiario;
    }

    public boolean utilizaWebService() {
        String parametro = this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_WEBSERVICE_MARINGA);
        return "1".equals(parametro);
    }

    @Generated
    public EstagiarioServiceImpl(EstagiarioRepository estagiarioRepository, PortalParametroService portalParametroService, IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService, EstagiarioServiceOxy serviceOxy, EntidadeAiseService entidadeAiseService) {
        this.estagiarioRepository = estagiarioRepository;
        this.portalParametroService = portalParametroService;
        this.integracaoAiseOxyService = integracaoAiseOxyService;
        this.serviceOxy = serviceOxy;
        this.entidadeAiseService = entidadeAiseService;
    }
}

