/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.portaltransparencia.admportal.converter.ArquivoDTOConverter;
import br.com.elotech.portaltransparencia.admportal.service.UsuarioService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.repository.ArquivoContabRepository;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import lombok.Generated;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PortalAdminArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalAdminArquivoService.class);
    @Autowired
    private ArquivoContabRepository repository;
    @Autowired
    private ArquivoStorageFeignClient arquivoClient;
    @Autowired
    private UsuarioService usuarioService;

    @Transactional
    public ArquivoContab adicionarArquivo(MultipartFile multipartFile) {
        AccessToken accessToken = (AccessToken)this.usuarioService.getAcessToken().get();
        ArquivoDTO novoArquivo = new ArquivoDTO();
        novoArquivo.setDataCriacao(LocalDate.now());
        novoArquivo.setMimeType(multipartFile.getContentType());
        novoArquivo.setNome(multipartFile.getOriginalFilename());
        novoArquivo.setTipo(TipoArquivoEnum.PUBLICACAO_PORTAL);
        novoArquivo.setModulo(Modulo.OXY_PORTAL_TRANSPARENCIA);
        novoArquivo.setUsuario(UUID.fromString(accessToken.getSubject()));
        Arquivo arquivoSalvo = ArquivoDTOConverter.getConverterInstance().from(this.arquivoClient.createWithFile(novoArquivo, multipartFile));
        ArquivoContab arquivoEntity = new ArquivoContab();
        arquivoEntity.setEloArquivo(arquivoSalvo);
        arquivoEntity.setNome(novoArquivo.getNome());
        arquivoEntity.setDataArquivo(LocalDateTime.now());
        arquivoEntity.setData(LocalDateTime.now());
        return (ArquivoContab)this.repository.save((Object)arquivoEntity);
    }

    @Transactional
    public void deletarArquivo(ArquivoContab arquivoEntity) {
        if (arquivoEntity != null) {
            this.repository.delete((Object)arquivoEntity);
            this.repository.flush();
        }
    }
}

