SELECT X.NOME,
       X.CNPJCPF,
       X.FORNECEDOR,
       X.EMPENHADO,
       X.ANULADO,
       X.LIQUIDADO,
       X.RETIDO,
       X.PAGO,
       (X.EMPENHADO-X.ANULADO-X.RETIDO-X.PAGO) AS APAGAR
  FROM (SELECT F.NOME,
               CASE WHEN F.TIPOPESSOA = 'F' 
                    THEN '****'||SUBSTR(F.CNPJ,5,3)||'****' 
                    ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2)
               END AS CNPJCPF,
               F.FORNECEDOR,
               SUM((SELECT SUM(FE.VALOR) 
                      FROM ${db.contabilidade.schema}.FICHAEMPENHO FE
                     WHERE E.EXERCICIO = FE.EXERCICIO
                       AND E.ENTIDADE = FE.ENTIDADE
                       AND E.EMPENHO = FE.EMPENHO
                       AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA)) AS EMPENHADO,
               SUM((SELECT SUM(FE.VALORANULACOES-FE.VALORESTANULACOES) 
                      FROM ${db.contabilidade.schema}.FICHAEMPENHO FE
                     WHERE E.EXERCICIO = FE.EXERCICIO
                       AND E.ENTIDADE = FE.ENTIDADE
                       AND E.EMPENHO = FE.EMPENHO
                       AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA)) AS ANULADO,
               SUM((SELECT SUM(FE.VALORLIQUIDACOES-FE.VALORESTLIQUIDACOES) 
                      FROM ${db.contabilidade.schema}.FICHAEMPENHO FE
                     WHERE E.EXERCICIO = FE.EXERCICIO
                       AND E.ENTIDADE = FE.ENTIDADE
                       AND E.EMPENHO = FE.EMPENHO
                       AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA)) AS LIQUIDADO,
               SUM((SELECT SUM(FE.VALORRETENCOES) 
                      FROM ${db.contabilidade.schema}.FICHAEMPENHO FE
                     WHERE E.EXERCICIO = FE.EXERCICIO
                       AND E.ENTIDADE = FE.ENTIDADE
                       AND E.EMPENHO = FE.EMPENHO
                       AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA)) AS RETIDO,
               SUM((SELECT SUM(FE.VALORPAGAMENTO-FE.VALORESTPAGAMENTO) 
                      FROM ${db.contabilidade.schema}.FICHAEMPENHO FE
                     WHERE E.EXERCICIO = FE.EXERCICIO
                       AND E.ENTIDADE = FE.ENTIDADE
                       AND E.EMPENHO = FE.EMPENHO
                       AND E.UNIDADEORCAMENTARIA = FE.UNIDADEORCAMENTARIA)) AS PAGO
          FROM ${db.contabilidade.schema}.EMPENHO E
          LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
            ON E.FORNECEDOR = F.FORNECEDOR
         WHERE $[TIPO_COMPRAS_DIRETAS] 
               $[FILTRO]
         GROUP BY F.NOME, 
                  CASE WHEN F.TIPOPESSOA = 'F' 
                       THEN '****'||SUBSTR(F.CNPJ,5,3)||'****' 
                       ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2)
                  END, 
                  F.FORNECEDOR) X 
 ORDER BY X.NOME   