/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.QuadroPessoalDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.servlet.ModelAndView;

public interface QuadroPessoalService {
    public Page<QuadroPessoalDTO> findQuadrosPessoal(CargoParams var1, Pageable var2);

    public List<QuadroPessoalDTO> findListQuadrosPessoal(CargoParams var1);

    public String findNomeEntidadeById(Long var1);

    public BaseExport getBaseExport();

    default public ModelAndView exportReport(HttpServletRequest request, HttpServletResponse response, @Valid CargoParams params, Pageable pageable, int size) throws Throwable {
        params.setExercicio(params.getExercicio());
        PageRequest pageRequest = PageRequest.of((int)0, (int)size, (Sort)pageable.getSort());
        Page quadrosPessoal = this.findQuadrosPessoal(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(this.findNomeEntidadeById(params.getEntidade()));
        reportParam.setReportTitle("Quadro de Pessoal");
        reportParam.setClazzDTO(QuadroPessoalDTO.class);
        reportParam.setHeaderFields("Tipo Cargo,Vagas Criadas,Vagas Ocupadas,Vagas Dispon\u00edveis");
        reportParam.setFields("tipoCargo,vagasCriadas,vagasOcupadas,vagasDisponiveis");
        float[] fieldsPerc = new float[]{1.0f, 0.7f, 0.5f, 2.0f, 0.7f, 1.0f, 2.8f, 1.3f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{30, 10, 10, 500, 15, 50, 1000, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(quadrosPessoal);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.getBaseExport().toExport(reportParam);
    }
}

