/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoContent;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

@Service
public class FindArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FindArquivoService.class);
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final RestTemplateBuilder restTemplateBuilder;

    public Arquivo findArquivoPortal(Long id) {
        ArquivoDTO arquivoDto = this.arquivoStorageFeignClient.findOne(id);
        Boolean isArquivoConvertidoS3 = Objects.nonNull(arquivoDto) && Objects.nonNull(arquivoDto.getFullPath()) && Objects.nonNull(arquivoDto.getModulo());
        if (isArquivoConvertidoS3.booleanValue()) {
            ArquivoContent arquivoContent = new ArquivoContent();
            arquivoContent.setId(id);
            arquivoContent.setBinary(this.baixarArquivoS3(arquivoDto));
            Arquivo arquivoEntity = new Arquivo();
            arquivoEntity.setId(id);
            arquivoEntity.setContent(arquivoContent);
            arquivoEntity.setNome(arquivoDto.getNome());
            arquivoEntity.setDataCriacao(LocalDate.now());
            return arquivoEntity;
        }
        throw new IllegalArgumentException(String.format("Arquivo [%s] n\u00e3o encontrado", id));
    }

    private byte[] baixarArquivoS3(ArquivoDTO arquivo) {
        ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(arquivo.getFullPath(), arquivo.getNome());
        byte[] contentByte = new byte[]{};
        log.info("Iniciando busca do conte\u00fado do arquivo.");
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplateBuilder.build().exchange(new URI(arquivoUrl.getUrlAssinada()), HttpMethod.GET, entity, byte[].class);
            contentByte = (byte[])response.getBody();
        }
        catch (URISyntaxException | RestClientException e) {
            log.error("Erro na busca do conte\u00fado do arquivo. Erro: {}", (Object)e.getMessage());
        }
        return contentByte;
    }

    @Generated
    public FindArquivoService(ArquivoStorageFeignClient arquivoStorageFeignClient, RestTemplateBuilder restTemplateBuilder) {
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.restTemplateBuilder = restTemplateBuilder;
    }
}

