/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.service;

import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoContent;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.arquivoportal.service.FindArquivoService;
import br.com.elotech.portaltransparencia.arquivoportal.service.FindArquivoServiceInt;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.nio.ByteBuffer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"!cloud"})
@Service
public class FindArquivoOxySustentacaoService
implements FindArquivoServiceInt {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FindArquivoOxySustentacaoService.class);
    private static final Long MAX_SIZE_POOL = 0xA00000L;
    private final Boolean isIntegradoOxy;
    private final FindArquivoService findArquivoService;
    private final EloArquivoRepository arquivoRepository;
    private final DatasourceWrapper datasourceWrapper;

    public FindArquivoOxySustentacaoService(FindArquivoService findArquivoService, EloArquivoRepository arquivoRepository, DatasourceWrapper datasourceWrapper, @Value(value="${elotech.integradooxy:false}") Boolean isIntegradoOxy) {
        this.findArquivoService = findArquivoService;
        this.arquivoRepository = arquivoRepository;
        this.datasourceWrapper = datasourceWrapper;
        this.isIntegradoOxy = isIntegradoOxy;
    }

    public Arquivo findArquivoPortal(Long id, boolean legado) {
        if (this.isIntegradoOxy.booleanValue() && !legado) {
            try {
                return this.findArquivoService.findArquivoPortal(id);
            }
            catch (Exception ex) {
                log.warn("N\u00e3o foi poss\u00edvel consultar o arquivo no \u00fanico. Fazendo fallback para eloarquivo. [{}]", (Object)ex.getMessage(), (Object)ex);
            }
        }
        if (SqlUtils.isPostgres((String)this.datasourceWrapper.getPlatform())) {
            return this.findArquivoByPart(id);
        }
        return this.findOne(id);
    }

    public Arquivo findOne(Long id) {
        return (Arquivo)this.arquivoRepository.findOne((Object)id);
    }

    public Arquivo findArquivoByPart(Long id) {
        Long tamanhoTotal = this.arquivoRepository.getTamanhoArquivo(id);
        if (tamanhoTotal != null && tamanhoTotal > MAX_SIZE_POOL) {
            String nome = this.arquivoRepository.getNameArquivo(id);
            Long posIni = 1L;
            Long posFim = MAX_SIZE_POOL;
            ByteBuffer allBytes = ByteBuffer.allocate(tamanhoTotal.intValue());
            while (posIni <= tamanhoTotal) {
                byte[] partBytes = posFim > tamanhoTotal ? this.arquivoRepository.getPartBytes(id, Integer.valueOf(posIni.intValue()), Integer.valueOf(tamanhoTotal.intValue() - posIni.intValue())) : this.arquivoRepository.getPartBytes(id, Integer.valueOf(posIni.intValue()), Integer.valueOf(MAX_SIZE_POOL.intValue()));
                allBytes.put(partBytes);
                posIni = posIni + MAX_SIZE_POOL;
                posFim = posIni + MAX_SIZE_POOL;
            }
            ArquivoContent content = new ArquivoContent();
            content.setBinary(allBytes.array());
            Arquivo arquivo = new Arquivo();
            arquivo.setId(id);
            arquivo.setNome(nome);
            arquivo.setContent(content);
            return arquivo;
        }
        return (Arquivo)this.arquivoRepository.findOne((Object)id);
    }
}

