/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.LinkUtil;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LinkUtilParams;
import br.com.elotech.portaltransparencia.contabportal.service.LinkUtilService;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/links-uteis", "/admin/api/links-uteis"})
public class LinkUtilResource {
    private final LinkUtilService linkUtilService;

    public LinkUtilResource(LinkUtilService linkUtilService) {
        this.linkUtilService = linkUtilService;
    }

    @GetMapping
    public ResponseEntity<List<LinkUtil>> findLinksUteis(@RequestParam(value="entidade") Long entidade, @RequestParam(value="tipo", required=false) Long tipo, LinkUtilParams params, Pageable pageable) {
        params.setEntidade(entidade);
        return ResponseEntity.ok((Object)this.linkUtilService.findLinksUteis(params));
    }

    @GetMapping(value={"/ativos"})
    public ResponseEntity<List<LinkUtil>> findLinksAtivos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @RequestParam(value="tipo", required=false) Long tipo, LinkUtilParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.linkUtilService.findLinksUteisAtivos(params));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<LinkUtil> findOne(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.linkUtilService.findLink(id));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<LinkUtil> updateLink(@RequestBody LinkUtil link, @PathVariable(value="id") Long id) {
        link.setId(id);
        LinkUtil updated = this.linkUtilService.saveLink(link);
        return ResponseEntity.ok((Object)updated);
    }

    @PostMapping
    public ResponseEntity<LinkUtil> saveLink(@RequestBody LinkUtil link) {
        return ResponseEntity.ok((Object)this.linkUtilService.saveLink(link));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<LinkUtil> deleteLink(@PathVariable(value="id") Long id) {
        LinkUtil link = this.linkUtilService.findLink(id);
        if (Objects.isNull(link)) {
            return ResponseEntity.notFound().build();
        }
        this.linkUtilService.deleteLink(link);
        return ResponseEntity.ok().build();
    }
}

