/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PortalOrcamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.PortalOrcamentoRepositoryCustom;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PortalOrcamentoParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PortalOrcamentoRepositoryImpl
implements PortalOrcamentoRepositoryCustom {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortalOrcamentoRepositoryImpl.class);
    private static final String ORCAMENTOS = "db/sql/contab/orcamentos.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public PortalOrcamentoRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<PortalOrcamentoDTO> findOrcamentos(PortalOrcamentoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ORCAMENTOS).replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        StringBuilder query = new StringBuilder(sql);
        query.append(this.filtros(params));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PortalOrcamentoDTO.class));
    }

    private String filtros(PortalOrcamentoParams params) {
        StringBuilder query = new StringBuilder();
        query.append(" A.ENTIDADE = :entidade ");
        params.getExercicio().ifPresent(item -> query.append(" AND ( A.EXERCICIO = :exercicio AND A.TIPO <> 'PPA' "));
        params.getAnoBasePPA().ifPresent(item -> query.append(" OR A.ANOBASEPPA = :anoBasePPA AND A.TIPO = 'PPA' ) "));
        return "WHERE " + query.toString();
    }
}

