/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service;

import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.HorasExtrasDetalhesDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.RegistroPontoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosPensaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidoresHorasExtrasDTO;
import br.com.elotech.portaltransparencia.web.rest.params.HorasExtrasDetalhesParams;
import br.com.elotech.portaltransparencia.web.rest.params.PermutaParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.servlet.ModelAndView;

public interface ServidorService {
    public Page<ServidorDTO> loadServidores(ServidorParams var1, Pageable var2);

    public Page<ServidorDTO> loadAposentadosPensionistas(ServidorParams var1, Pageable var2);

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams var1);

    public List<RegistroPontoDTO> loadRegistroPonto(ServidorParams var1);

    public List<String> getSituacoes(Long var1, Long var2);

    public List<ServidorResumoNaturezaDTO> loadServidoresResumoNatureza(ServidorParams var1);

    public Optional<ServidorDadosPensaoDTO> loadPensaoServidor(ServidorParams var1);

    public boolean utilizaWebService();

    public Optional<ServidorDTO> loadServidor(ServidorParams var1);

    public Optional<ServidoresHorasExtrasDTO> loadServidoresHorasExtras(ServidorParams var1);

    public Page<PermutaDTO> loadPermutas(PermutaParams var1, Pageable var2);

    public List<HorasExtrasDetalhesDTO> loadHorasExtrasDetalhes(HorasExtrasDetalhesParams var1);

    public List<PortalTransparenciaLotacaoDTO> findVerbas(Long var1, ServidorParams var2);

    public List<PortalTransparenciaLotacaoServidorDTO> findVerbaDetalhes(Long var1, ServidorParams var2);

    public String findNomeEntidadeById(Long var1);

    public BaseExport getBaseExport();

    public Boolean isIntegradoOxy();

    default public ModelAndView exportReport(HttpServletRequest request, HttpServletResponse response, ServidorParams servidorParams, Page<ServidorDTO> servidoresPage) throws Throwable {
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(this.findNomeEntidadeById(servidorParams.getEntidade()));
        reportParam.setReportTitle("Servidores");
        reportParam.setClazzDTO(ServidorDTO.class);
        String headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Cargo/Fun\u00e7\u00e3o,Classe/Natureza,Lota\u00e7\u00e3o";
        String fields = "nome,matricula,situacao,descricaoCargo,descricaoClasse,descricaoLotacao";
        float[] fieldsPerc = new float[]{1.5f, 0.9f, 1.0f, 1.5f, 1.8f, 1.8f};
        int[] fieldTab = new int[]{100, 20, 20, 100, 100, 100};
        if (!this.isIntegradoOxy().booleanValue()) {
            headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Cargo,Classe,Natureza,Lota\u00e7\u00e3o";
            fields = "nome,matricula,situacao,descricaoCargo,descricaoClasse,descricaoNatureza,descricaoLotacao";
            fieldsPerc = new float[]{1.5f, 0.9f, 1.0f, 1.5f, 1.8f, 1.5f, 1.8f};
            fieldTab = new int[]{100, 20, 20, 100, 100, 100, 100};
        }
        if (this.utilizaWebService()) {
            headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Cargo,Lota\u00e7\u00e3o";
            fields = "nome,matricula,situacao,descricaoCargo,descricaoLotacao";
            fieldsPerc = new float[]{1.5f, 0.9f, 1.0f, 1.5f, 1.8f};
            fieldTab = new int[]{100, 20, 20, 100, 100};
        }
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(servidoresPage);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(servidorParams.getExportType());
        return this.getBaseExport().toExport(reportParam);
    }
}

