/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoSubGrupoExercicioRepository;
import br.com.elotech.portaltransparencia.admportal.service.PublicacaoService;
import br.com.elotech.portaltransparencia.contabportal.domain.Publicacao;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupoExercicio;
import java.io.IOException;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/publicacoes"})
public class PublicacaoAdmResource
extends CrudResource<Publicacao, Long> {
    private final PublicacaoSubGrupoExercicioRepository grupoExercicioRepository;

    public PublicacaoAdmResource(PublicacaoSubGrupoExercicioRepository grupoExercicioRepository) {
        this.grupoExercicioRepository = grupoExercicioRepository;
    }

    public PublicacaoService getService() {
        return (PublicacaoService)super.getService();
    }

    @GetMapping(value={"/grupos"})
    public ResponseEntity<Page<PublicacaoSubGrupoExercicio>> findAllGrupos(@RequestParam(value="search") Optional<String> search) {
        return ResponseEntity.ok((Object)this.grupoExercicioRepository.findAll(RsqlUtils.createSpecFrom((EntityManager)this.getService().getEm(), (String)search.orElse(""), Optional.empty()), Pageable.unpaged()));
    }

    @PostMapping(value={"/{id}/arquivo"})
    public ResponseEntity<Publicacao> salvarArquivo(@PathVariable(name="id") Long id, @RequestParam(value="files") MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.getService().adicionarArquivoPublicacao(id, file));
    }

    @DeleteMapping(value={"/{id}/arquivo"})
    public ResponseEntity<Publicacao> deletarArquivo(@PathVariable(name="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().removerArquivoPublicacao(id));
    }
}

