/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.saude.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.portaltransparencia.saude.domain.dto.DocumentoDTO;
import br.com.elotech.portaltransparencia.saude.service.DocumentosService;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/documentos-saude"})
public class DocumentosResource {
    private final DocumentosService documentosService;

    public DocumentosResource(DocumentosService documentosService) {
        this.documentosService = documentosService;
    }

    @GetMapping
    public ResponseEntity<List<DocumentoDTO>> findDocumentos() {
        return ResponseEntity.ok((Object)this.documentosService.findDocumentos());
    }

    @GetMapping(value={"/{id}"})
    public void getArquivo(@PathVariable Long id, HttpServletResponse response) throws IOException {
        DocumentoDTO documentoDTO = this.documentosService.getArquivo(id);
        if (!Objects.nonNull(documentoDTO) || !Objects.nonNull(documentoDTO.getArquivo())) {
            throw RestException.notFound((String)"Arquivo n\u00e3o encontrado!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])Base64.getDecoder().decode(documentoDTO.getArquivo()), (String)documentoDTO.getNome());
    }
}

