/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.ProcessoMailService;
import br.com.elotech.portaltransparencia.protocportal.domain.PROTOCParametro;
import br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
public class ProcessoMailServiceImpl
implements ProcessoMailService {
    private final Logger log = LoggerFactory.getLogger(ProcessoMailServiceImpl.class);
    private final Locale locale = Locale.getDefault();
    private final MessageSource messageSource;
    private final ITemplateEngine templateEngine;
    private final MailService mailService;
    private final PortalParametroRepository portalParametroRepository;
    private final EntidadeContabilidadeService entidadeService;
    private final ParametroService parametroService;

    public ProcessoMailServiceImpl(MessageSource messageSource, SpringTemplateEngine templateEngine, MailService mailService, PortalParametroRepository portalParametroRepository, EntidadeContabilidadeService entidadeService, ParametroService parametroService) {
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
        this.mailService = mailService;
        this.portalParametroRepository = portalParametroRepository;
        this.entidadeService = entidadeService;
        this.parametroService = parametroService;
    }

    public Future<Boolean> enviaeSicEmail(ProcessoDTO processo) {
        this.log.debug("Enviando email do eSic para '{}'", (Object)processo.getEmail());
        String content = this.buildContent(processo);
        String subject = this.messageSource.getMessage("email.esic.title", null, this.locale);
        MailParams params = MailParams.builder().to(processo.getEmail()).subject(subject).encoding("ISO-8859-1").content(content).multipart(false).html(true).build();
        return this.mailService.sendEmail(params);
    }

    private String buildContent(ProcessoDTO processo) {
        Context context = new Context(this.locale);
        context.setVariable("email", (Object)processo.getEmail());
        context.setVariable("requerente", (Object)processo.getRequerente());
        String baseUrl = processo.getUrl() + "/portaltransparencia/esic?";
        context.setVariable("baseUrl", (Object)baseUrl);
        context.setVariable("entidade", (Object)processo.getEntidade());
        context.setVariable("exercicio", (Object)processo.getExercicio());
        context.setVariable("numero", (Object)processo.getProcesso());
        context.setVariable("senha", (Object)processo.getSenha());
        context.setVariable("assunto", (Object)processo.getAssunto());
        context.setVariable("digitacao", (Object)processo.getDigitacao());
        context.setVariable("entidadeNome", (Object)this.getNomeEntidade(processo.getEntidade()));
        Optional templateEmail = this.parametroService.findParametroByEntidadeExercicioCodigo(Long.valueOf(Long.parseLong(processo.getEntidade())), Long.valueOf(Long.parseLong(processo.getExercicio())), Long.valueOf(104L));
        if (templateEmail.isPresent() && ((PROTOCParametro)templateEmail.get()).getValor().isPresent()) {
            return this.templateEngine.process((String)((PROTOCParametro)templateEmail.get()).getValor().get(), (IContext)context);
        }
        return this.templateEngine.process("esicEmail", (IContext)context);
    }

    public Future<Boolean> enviaContatoEmail(ProcessoDTO processo) {
        PortalParametroContabil paramEmailContato = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ATENDIMENTO_EMAIL);
        if (paramEmailContato != null && !paramEmailContato.getValor().trim().equals("")) {
            this.log.debug("Enviando email do eSic para '{}'", (Object)paramEmailContato.getValor());
            String content = this.buildContentContato(processo, paramEmailContato.getValor());
            String subject = this.messageSource.getMessage("email.esic.title", null, this.locale);
            MailParams params = MailParams.builder().to(paramEmailContato.getValor()).subject(subject).content(content).multipart(false).html(true).build();
            return this.mailService.sendEmail(params);
        }
        this.log.warn("Par\u00e2metro email contato n\u00e3o configurado corretamente. [{} - {} - {}]", new Object[]{Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_ATENDIMENTO_EMAIL});
        return ConcurrentUtils.constantFuture((Object)false);
    }

    private String buildContentContato(ProcessoDTO processo, String email) {
        Context context = new Context(this.locale);
        context.setVariable("email", (Object)email);
        context.setVariable("requerente", (Object)processo.getRequerente());
        String baseUrl = processo.getUrl() + "/portaltransparencia/esic?";
        context.setVariable("baseUrl", (Object)baseUrl);
        context.setVariable("entidade", (Object)processo.getEntidade());
        context.setVariable("exercicio", (Object)processo.getExercicio());
        context.setVariable("numero", (Object)processo.getProcesso());
        context.setVariable("senha", (Object)processo.getSenha());
        context.setVariable("assunto", (Object)processo.getAssunto());
        context.setVariable("digitacao", (Object)processo.getDigitacao());
        context.setVariable("entidadeNome", (Object)this.getNomeEntidade(processo.getEntidade()));
        return this.templateEngine.process("contatoEmail", (IContext)context);
    }

    private String getNomeEntidade(String idEntidade) {
        Entidade entidade;
        if (Objects.nonNull(idEntidade) && Objects.nonNull(entidade = this.entidadeService.findOne(Long.valueOf(idEntidade)))) {
            return entidade.getNome();
        }
        return "";
    }
}

