/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.Comparators;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.repository.CGAtoRepository;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosNaturezaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LegislativoDecretoRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.LegislativoLeiRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.LegislativoPortariaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.LeisAtosRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.LgLeisAtosRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import br.com.elotech.portaltransparencia.contabportal.service.LeisAtosService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class LeisAtosServiceImpl
implements LeisAtosService {
    private final LeisAtosRepository leisAtosRepository;
    private final CGAtoRepository cgAtoRepository;
    private final LgLeisAtosRepository lgLeisAtosRepository;
    private final LegislativoLeiRepository legislativoLeiRepository;
    private final LegislativoDecretoRepository legislativoDecretoRepository;
    private final LegislativoPortariaRepository legislativoPortariaRepository;
    private final PortalParametroService portalParametroService;
    private final ArquivoService arquivoService;
    private final IntegracaoOxyFolhaPagamentoService integracaoOxyFolhaPagamentoService;
    private static final String LEIDESC = "Lei";
    private static final String DECRETODESC = "Decreto";
    private static final String PORTARIADESC = "Portaria";
    private static final String AISE = "A";
    private static final String CONTAB = "C";
    private static final String LEGISLATIVO = "L";
    private static final String GERAL = "geral";
    private static final String PESSOAL = "pessoal";
    private static final Object DESPESA = "despesa";
    private static final Object RECEITA = "receita";

    @Autowired
    public LeisAtosServiceImpl(LeisAtosRepository leisAtosRepository, CGAtoRepository cgAtoRepository, LgLeisAtosRepository lgLeisAtosRepository, LegislativoLeiRepository legislativoLeiRepository, LegislativoDecretoRepository legislativoDecretoRepository, LegislativoPortariaRepository legislativoPortariaRepository, PortalParametroService portalParametroService, ArquivoService arquivoService, IntegracaoOxyFolhaPagamentoService integracaoOxyFolhaPagamentoService) {
        this.leisAtosRepository = leisAtosRepository;
        this.cgAtoRepository = cgAtoRepository;
        this.lgLeisAtosRepository = lgLeisAtosRepository;
        this.legislativoLeiRepository = legislativoLeiRepository;
        this.legislativoDecretoRepository = legislativoDecretoRepository;
        this.legislativoPortariaRepository = legislativoPortariaRepository;
        this.portalParametroService = portalParametroService;
        this.arquivoService = arquivoService;
        this.integracaoOxyFolhaPagamentoService = integracaoOxyFolhaPagamentoService;
    }

    public LeisAtosDTO findOneLeiAto(LeisAtosParams params) {
        if (this.integracaoOxyFolhaPagamentoService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return this.integracaoOxyFolhaPagamentoService.findAto(params);
        }
        String sistema = params.getSistema().orElse("");
        if (sistema.equals(AISE)) {
            return this.findOneAise(params);
        }
        if (sistema.equals(CONTAB)) {
            return this.findOneSiscop(params);
        }
        if (sistema.equals(LEGISLATIVO)) {
            return this.findOneLegislativo(params);
        }
        return null;
    }

    private LeisAtosDTO findOneLegislativo(LeisAtosParams params) {
        String natureza = params.getNatureza().orElse("");
        LeisAtosDTO lgLeisAtos = new LeisAtosDTO();
        if (LEIDESC.equalsIgnoreCase(natureza)) {
            lgLeisAtos = this.lgLeisAtosRepository.findLgLei(params).stream().findFirst().orElse(null);
        } else if (DECRETODESC.equalsIgnoreCase(natureza)) {
            lgLeisAtos = this.lgLeisAtosRepository.findLgDecreto(params).stream().findFirst().orElse(null);
        } else if (PORTARIADESC.equalsIgnoreCase(natureza)) {
            lgLeisAtos = this.lgLeisAtosRepository.findLgPortaria(params).stream().findFirst().orElse(null);
        }
        if (Objects.nonNull(lgLeisAtos)) {
            List arquivos = this.lgLeisAtosRepository.findLgLeisArquivos(lgLeisAtos.getExercicio(), lgLeisAtos.getId(), lgLeisAtos.getTipo(), natureza);
            lgLeisAtos.setArquivos(arquivos);
        }
        return lgLeisAtos;
    }

    private LeisAtosDTO findOneSiscop(LeisAtosParams params) {
        LeisAtosDTO lei = this.leisAtosRepository.findOneLeiAto(params).stream().findFirst().orElse(null);
        if (Objects.nonNull(lei)) {
            List vinculadas = this.leisAtosRepository.findLeisVinculadas(lei.getEntidade(), lei.getExercicio(), lei.getId());
            List arquivos = this.leisAtosRepository.findLeisArquivos(lei.getEntidade(), lei.getExercicio(), lei.getId());
            lei.setLeisVinculadas(vinculadas);
            lei.setArquivos(arquivos);
        }
        return lei;
    }

    private LeisAtosDTO findOneAise(LeisAtosParams params) {
        LeisAtosDTO leiAto = this.cgAtoRepository.findLeisAtos(params).stream().findFirst().orElse(new LeisAtosDTO());
        if (Objects.nonNull(leiAto) && leiAto.hasArquivo() && Objects.nonNull(leiAto.getIdArquivo())) {
            Arquivo arquivo = this.arquivoService.findOne(leiAto.getIdArquivo());
            LeisAtosArquivoDTO arquivoDTO = new LeisAtosArquivoDTO();
            arquivoDTO.setId(leiAto.getIdArquivo());
            arquivoDTO.setIdArquivo(leiAto.getIdArquivo());
            if (Objects.nonNull(arquivo)) {
                arquivoDTO.setNomeArquivo(arquivo.getNome());
            }
            arquivoDTO.setDataPublicacao(leiAto.getDataPublicacao());
            leiAto.getArquivos().add(arquivoDTO);
        }
        return leiAto;
    }

    public Page<LeisAtosDTO> findLeisAtos(LeisAtosParams params, Pageable pageable) {
        if (this.integracaoOxyFolhaPagamentoService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return this.integracaoOxyFolhaPagamentoService.findAtos(params, pageable);
        }
        List leis = this.queryForLeis(params);
        List leisPage = this.retrievePage(leis, pageable);
        return new PageImpl(leisPage, pageable, (long)leis.size());
    }

    private List<LeisAtosDTO> queryForLeis(LeisAtosParams params) {
        ArrayList<LeisAtosDTO> leis = new ArrayList<LeisAtosDTO>();
        if (Objects.isNull(params.getEntidade())) {
            return leis;
        }
        Boolean showContabil = this.showLeisAtos(params, Parametros.PARAM_LEI_ATOS_CONTABIL);
        Boolean showLegislativo = this.showLeisAtos(params, Parametros.PARAM_LEI_ATOS_LEGISLATIVO);
        String subAba = params.getSubAbaLeiAtos().orElse("");
        if (GERAL.equals(subAba)) {
            this.findLeisAtosGeral(params, leis, showContabil, showLegislativo);
        } else if (PESSOAL.equals(subAba)) {
            this.findLeisAtosPessoal(params, leis);
        } else if (showContabil.booleanValue() && (DESPESA.equals(subAba) || RECEITA.equals(subAba))) {
            this.findLeisAtosContabil(params, leis);
        }
        return leis;
    }

    private void findLeisAtosGeral(LeisAtosParams params, List<LeisAtosDTO> leis, Boolean showContabil, Boolean showLegislativo) {
        if (showContabil.booleanValue() && !params.getIsCovid().isPresent()) {
            this.findLeisAtosContabil(params, leis);
        }
        if (this.showAise(params).booleanValue() && !params.getIsCovid().isPresent()) {
            this.findLeisAtosAise(params, leis);
        }
        if (showLegislativo.booleanValue()) {
            this.findLeisAtosLegislativo(params, leis);
        }
    }

    private Boolean showAise(LeisAtosParams params) {
        return this.showLeisAtos(params, Parametros.PARAM_LEI_ATOS_AISE);
    }

    private void findLeisAtosPessoal(LeisAtosParams params, List<LeisAtosDTO> leis) {
        this.findLeisAtosContabil(params, leis);
        if (this.showAise(params).booleanValue()) {
            this.findLeisAtosAise(params, leis);
        }
    }

    protected void findLeisAtosContabil(LeisAtosParams params, List<LeisAtosDTO> leis) {
        leis.addAll(this.leisAtosRepository.findLeisAtos(params));
    }

    protected void findLeisAtosAise(LeisAtosParams params, List<LeisAtosDTO> leis) {
        leis.addAll(this.cgAtoRepository.findLeisAtos(params));
    }

    protected void findLeisAtosLegislativo(LeisAtosParams params, List<LeisAtosDTO> leis) {
        leis.addAll(this.lgLeisAtosRepository.findLgLei(params));
        leis.addAll(this.lgLeisAtosRepository.findLgDecreto(params));
        leis.addAll(this.lgLeisAtosRepository.findLgPortaria(params));
    }

    private boolean showLeisAtos(LeisAtosParams params, Long codigoParametro) {
        String parametroValor = this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), codigoParametro);
        return Objects.nonNull(parametroValor) && SimNao.toBoolean((String)parametroValor, (Boolean)false) != false;
    }

    private List<LeisAtosDTO> retrievePage(List<LeisAtosDTO> leis, Pageable pageable) {
        Comparator comparator = Comparators.comparingField(LeisAtosDTO.class, (String)"data").reversed();
        if (Objects.nonNull(pageable.getSort()) && pageable.getSort().iterator().hasNext()) {
            Sort.Order order = (Sort.Order)pageable.getSort().iterator().next();
            comparator = Comparators.comparingField(LeisAtosDTO.class, (String)order.getProperty());
            if (order.isDescending()) {
                comparator = comparator.reversed();
            }
        }
        return leis.stream().filter(i -> Objects.nonNull(i.getExercicio()) && Objects.nonNull(i.getNatureza()) && Objects.nonNull(i.getId())).sorted(comparator).skip((long)pageable.getPageNumber() * (long)pageable.getPageSize()).limit(pageable.getPageSize()).collect(Collectors.toList());
    }

    public ArquivoDTO findArquivoLegislacao(Long id, Long idArquivo, Long anoLei, String natureza, Long tipo, String tabela) {
        switch (natureza) {
            case "Lei": {
                return this.legislativoLeiRepository.findOne(id, idArquivo, anoLei, tabela);
            }
            case "Decreto": {
                return this.legislativoDecretoRepository.findOne(id, idArquivo, anoLei, tabela);
            }
            case "Portaria": {
                return this.legislativoPortariaRepository.findOne(id, idArquivo, anoLei, tipo, tabela);
            }
        }
        return new ArquivoDTO();
    }

    public ArquivoDTO findArquivoLegislacao(Long id, Long idArquivo, Long anoLei, String natureza, String tabela) {
        return this.findArquivoLegislacao(id, idArquivo, anoLei, natureza, null, tabela);
    }

    public List<LeisAtosNaturezaDTO> findLeisAtosNatureza(LeisAtosParams params) {
        if (this.integracaoOxyFolhaPagamentoService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return this.integracaoOxyFolhaPagamentoService.findNaturezas(params);
        }
        return this.leisAtosRepository.findLeisAtosNatureza(params);
    }

    public List<LeisAtosNaturezaDTO> findTiposDocumentoLegal(LeisAtosParams params) {
        if (this.integracaoOxyFolhaPagamentoService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Arrays.asList(new LeisAtosNaturezaDTO());
        }
        return this.leisAtosRepository.findTiposDocumentoLegal();
    }

    public List<LeisAtosNaturezaDTO> findTiposEscopo(LeisAtosParams params) {
        if (this.integracaoOxyFolhaPagamentoService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Arrays.asList(new LeisAtosNaturezaDTO());
        }
        return this.leisAtosRepository.findTiposEscopo();
    }
}

